/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import java.io.IOException;
import java.util.List;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.PersistenceMode;
import org.sonar.api.measures.RangeDistributionBuilder;
import org.sonar.api.resources.InputFile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.plugins.python.ComplexityStat;
import org.sonar.plugins.python.PythonComplexityAnalyzer;
import org.sonar.plugins.python.PythonFile;
import org.sonar.plugins.python.PythonSensor;

public final class PythonComplexitySensor
extends PythonSensor {
    private static final Number[] FUNCTIONS_DISTRIB_BOTTOM_LIMITS = new Number[]{1, 2, 4, 6, 8, 10, 12, 20, 30};
    private static final Number[] FILES_DISTRIB_BOTTOM_LIMITS = new Number[]{0, 5, 10, 20, 30, 60, 90};

    protected void analyzeFile(InputFile inputFile, Project project, SensorContext sensorContext) throws IOException {
        PythonFile pyfile = PythonFile.fromIOFile(inputFile.getFile(), project);
        PythonComplexityAnalyzer analyzer = new PythonComplexityAnalyzer(project);
        List<ComplexityStat> stats = analyzer.analyzeComplexity(inputFile.getFile().getPath());
        ComplexityStat globalScopeStat = stats.get(0);
        List<ComplexityStat> functionStats = stats.subList(1, stats.size());
        int fileComplexity = 0;
        int cumFuncComplexity = 0;
        for (ComplexityStat stat : functionStats) {
            cumFuncComplexity += stat.count;
        }
        fileComplexity = cumFuncComplexity + globalScopeStat.count;
        sensorContext.saveMeasure((Resource)pyfile, CoreMetrics.COMPLEXITY, Double.valueOf(fileComplexity));
        RangeDistributionBuilder fileDistribution = new RangeDistributionBuilder(CoreMetrics.FILE_COMPLEXITY_DISTRIBUTION, FILES_DISTRIB_BOTTOM_LIMITS);
        fileDistribution.add((Number)fileComplexity);
        sensorContext.saveMeasure((Resource)pyfile, fileDistribution.build().setPersistenceMode(PersistenceMode.MEMORY));
        if (!functionStats.isEmpty()) {
            sensorContext.saveMeasure((Resource)pyfile, CoreMetrics.FUNCTION_COMPLEXITY, Double.valueOf((double)cumFuncComplexity / (double)functionStats.size()));
            RangeDistributionBuilder functionDistribution = new RangeDistributionBuilder(CoreMetrics.FUNCTION_COMPLEXITY_DISTRIBUTION, FUNCTIONS_DISTRIB_BOTTOM_LIMITS);
            for (ComplexityStat stat : functionStats) {
                functionDistribution.add((Number)stat.count);
            }
            sensorContext.saveMeasure((Resource)pyfile, functionDistribution.build().setPersistenceMode(PersistenceMode.MEMORY));
        }
    }
}

