/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import java.io.IOException;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.resources.InputFile;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.SonarException;

public abstract class PythonSensor
implements Sensor {
    public boolean shouldExecuteOnProject(Project project) {
        return "py".equals(project.getLanguageKey());
    }

    public void analyse(Project project, SensorContext sensorContext) {
        for (InputFile inputFile : project.getFileSystem().mainFiles(new String[]{"py"})) {
            try {
                this.analyzeFile(inputFile, project, sensorContext);
            }
            catch (Exception e) {
                String msg = "Cannot analyse the file '" + inputFile.getFile().getAbsolutePath() + "', details: '" + e + "'";
                throw new SonarException(msg, (Throwable)e);
            }
        }
    }

    protected abstract void analyzeFile(InputFile var1, Project var2, SensorContext var3) throws IOException;
}

