/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.resources.InputFile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.plugins.python.PythonFile;
import org.sonar.plugins.python.PythonRecognizer;
import org.sonar.plugins.python.PythonSensor;
import org.sonar.squid.measures.Metric;
import org.sonar.squid.recognizer.CodeRecognizer;
import org.sonar.squid.text.Source;

public final class PythonSquidSensor
extends PythonSensor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void analyzeFile(InputFile inputFile, Project project, SensorContext sensorContext) throws IOException {
        StringReader reader = null;
        try {
            reader = new StringReader(FileUtils.readFileToString((File)inputFile.getFile(), (String)project.getFileSystem().getSourceCharset().name()));
            PythonFile pyfile = PythonFile.fromIOFile(inputFile.getFile(), project);
            Source source = new Source((Reader)reader, (CodeRecognizer)new PythonRecognizer(), new String[]{"#"});
            sensorContext.saveMeasure((Resource)pyfile, CoreMetrics.FILES, Double.valueOf(1.0));
            sensorContext.saveMeasure((Resource)pyfile, CoreMetrics.LINES, Double.valueOf(source.getMeasure(Metric.LINES)));
            sensorContext.saveMeasure((Resource)pyfile, CoreMetrics.COMMENT_LINES, Double.valueOf(source.getMeasure(Metric.COMMENT_LINES)));
            sensorContext.saveMeasure((Resource)pyfile, CoreMetrics.NCLOC, Double.valueOf(source.getMeasure(Metric.LINES_OF_CODE)));
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
    }
}

