/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.InputFile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.rules.Violation;
import org.sonar.plugins.python.Issue;
import org.sonar.plugins.python.PythonFile;
import org.sonar.plugins.python.PythonPlugin;
import org.sonar.plugins.python.PythonSensor;
import org.sonar.plugins.python.PythonViolationsAnalyzer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PythonViolationsSensor
extends PythonSensor {
    private static final String PYTHONPATH_ENVVAR = "PYTHONPATH";
    private RuleFinder ruleFinder;
    private RulesProfile profile;
    private Configuration conf;
    private String[] environment;

    public PythonViolationsSensor(RuleFinder ruleFinder, Project project, Configuration conf, RulesProfile profile) {
        this.ruleFinder = ruleFinder;
        this.conf = conf;
        this.profile = profile;
        this.environment = PythonViolationsSensor.getEnvironment(project);
    }

    @Override
    public boolean shouldExecuteOnProject(Project project) {
        return super.shouldExecuteOnProject(project) && !this.profile.getActiveRulesByRepository("Pylint").isEmpty();
    }

    @Override
    protected void analyzeFile(InputFile inputFile, Project project, SensorContext sensorContext) throws IOException {
        PythonFile pyfile = PythonFile.fromIOFile(inputFile.getFile(), project);
        String pylintConfigPath = PythonViolationsSensor.getPylintConfigPath(project);
        String pylintPath = this.conf.getString("sonar.python.pylint", null);
        PythonViolationsAnalyzer analyzer = new PythonViolationsAnalyzer(pylintPath, pylintConfigPath);
        List<Issue> issues = analyzer.analyze(inputFile.getFile().getPath(), this.environment);
        for (Issue issue : issues) {
            Rule rule = this.ruleFinder.findByKey("Pylint", issue.ruleId);
            if (rule != null) {
                if (rule.isEnabled().booleanValue()) {
                    Violation violation = Violation.create((Rule)rule, (Resource)pyfile);
                    violation.setLineId(Integer.valueOf(issue.line));
                    violation.setMessage(issue.descr);
                    sensorContext.saveViolation(violation);
                    continue;
                }
                PythonPlugin.LOG.debug("Pylint rule '{}' is disabled in Sonar", (Object)issue.ruleId);
                continue;
            }
            PythonPlugin.LOG.warn("Pylint rule '{}' is unknown in Sonar", (Object)issue.ruleId);
        }
    }

    protected static final String[] getEnvironment(Project project) {
        String[] environ = null;
        String pythonPathProp = (String)project.getProperty("sonar.python.path");
        if (pythonPathProp != null) {
            File projectRoot = project.getFileSystem().getBasedir();
            String[] parsedPaths = StringUtils.split((String)pythonPathProp, (String)",");
            List<String> absPaths = PythonViolationsSensor.toAbsPaths(parsedPaths, projectRoot);
            String delimiter = System.getProperty("path.separator");
            String pythonPath = StringUtils.join(absPaths, (String)delimiter);
            environ = new String[]{"PYTHONPATH=" + pythonPath};
        }
        return environ;
    }

    private static List<String> toAbsPaths(String[] pathStrings, File baseDir) {
        LinkedList<String> result = new LinkedList<String>();
        for (String pathStr : pathStrings) {
            pathStr = StringUtils.trim((String)pathStr);
            result.add(new File(baseDir, pathStr).getPath());
        }
        return result;
    }

    protected static String getPylintConfigPath(Project project) {
        String absConfigPath = null;
        String configPath = (String)project.getProperty("sonar.python.pylint_config");
        if (configPath != null && !"".equals(configPath)) {
            File projectRoot = project.getFileSystem().getBasedir();
            absConfigPath = new File(projectRoot.getPath(), configPath).getPath();
        }
        return absConfigPath;
    }
}

