/*
 * Decompiled with CFR 0.152.
 */
package org.codetome.riptide.core.adapter.rabbit;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.BuiltinExchangeType;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.codetome.riptide.core.adapter.rabbit.RabbitConfig;
import org.codetome.riptide.core.adapter.rabbit.RabbitNamingStrategy;
import org.codetome.riptide.core.api.exception.MissingMessageReceiverException;
import org.codetome.riptide.core.api.exception.MissingNameException;
import org.codetome.riptide.core.api.exception.MissingOperationException;
import org.codetome.riptide.core.domain.Message;
import org.codetome.riptide.core.domain.OperationDescriptor;
import org.codetome.riptide.core.domain.ProcessEvent;
import org.codetome.riptide.core.service.messaging.MessageReceiver;
import org.codetome.riptide.core.service.messaging.MessagingAdapter;
import org.codetome.riptide.core.service.process.ProcessEventService;
import org.codetome.riptide.protobuf.ProtoMessage;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 )2\u00020\u0001:\u0001)B#\b\u0000\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J \u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000fH\u0002J\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u000fH\u0002J\u0014\u0010!\u001a\u00020\u00172\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#H\u0016J\u0014\u0010$\u001a\u00020%2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#H\u0016J\u000e\u0010&\u001a\u00020%2\u0006\u0010\u0012\u001a\u00020\u0014J\u0010\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020\u0017H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/codetome/riptide/core/adapter/rabbit/RabbitMessagingAdapter;", "Lorg/codetome/riptide/core/service/messaging/MessagingAdapter;", "rabbitConfig", "Lorg/codetome/riptide/core/adapter/rabbit/RabbitConfig;", "processEventService", "Lorg/codetome/riptide/core/service/process/ProcessEventService;", "rabbitNamingStrategy", "Lorg/codetome/riptide/core/adapter/rabbit/RabbitNamingStrategy;", "(Lorg/codetome/riptide/core/adapter/rabbit/RabbitConfig;Lorg/codetome/riptide/core/service/process/ProcessEventService;Lorg/codetome/riptide/core/adapter/rabbit/RabbitNamingStrategy;)V", "connection", "Lcom/rabbitmq/client/Connection;", "inboundChannel", "Lcom/rabbitmq/client/Channel;", "knownExchanges", "", "", "logger", "Lorg/slf4j/Logger;", "messageReceiver", "Ljava/util/Optional;", "Lorg/codetome/riptide/core/service/messaging/MessageReceiver;", "operations", "", "Lorg/codetome/riptide/core/domain/OperationDescriptor;", "outboundChannel", "createConnectionFactory", "Lcom/rabbitmq/client/ConnectionFactory;", "declareAndBindQueueFor", "exchangeName", "queueName", "routingKey", "declareExchangeFor", "operationName", "fetchOperationFor", "message", "Lorg/codetome/riptide/core/domain/Message;", "publish", "", "setMessageReceiver", "subscribe", "operation", "Companion", "riptide.core.java_main"})
public final class RabbitMessagingAdapter
implements MessagingAdapter {
    private final Logger logger;
    private final Connection connection;
    private final Channel inboundChannel;
    private final Channel outboundChannel;
    private final Set<String> knownExchanges;
    private final List<OperationDescriptor> operations;
    private Optional<MessageReceiver> messageReceiver;
    private final ProcessEventService processEventService;
    private final RabbitNamingStrategy rabbitNamingStrategy;
    private static final boolean DURABLE = false;
    private static final boolean AUTO_DELETE = true;
    private static final boolean EXCLUSIVE = false;
    private static final boolean AUTO_ACK = true;
    public static final Companion Companion = new Companion(null);

    @Override
    public void publish(@NotNull Message<?> message) {
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        String exchangeName = this.rabbitNamingStrategy.generateExchangeName(message.getOperation());
        if (StringsKt.isBlank((CharSequence)message.getOperation())) {
            throw (Throwable)new MissingNameException();
        }
        if (!this.knownExchanges.contains(exchangeName)) {
            this.declareExchangeFor(message.getOperation());
            this.knownExchanges.add(exchangeName);
        }
        String routingKey = this.rabbitNamingStrategy.generateRoutingKey(message.getGroup(), message.getVersion(), message.getOperation(), message.getCustomRoutingParameters());
        this.logger.info("Publishing message of type '{}' to exchange: '{}' with routing key: '{}'", new Object[]{message.getPayloadType$riptide_core_java_main(), exchangeName, routingKey});
        this.outboundChannel.basicPublish(exchangeName, routingKey, null, message.toProtobuf$riptide_core_java_main().toByteArray());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void subscribe(@NotNull OperationDescriptor operation) {
        Collection<String> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        this.operations.add(operation);
        String exchangeName = this.declareExchangeFor(operation.getName());
        this.knownExchanges.add(exchangeName);
        String queueName = this.rabbitNamingStrategy.generateQueueName(operation);
        Iterable iterable = operation.getCustomRoutingParameters();
        String string = operation.getName();
        String string2 = operation.getVersionName();
        String string3 = operation.getGroupName();
        RabbitNamingStrategy rabbitNamingStrategy = this.rabbitNamingStrategy;
        void var6_9 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            String string4;
            void p1;
            void var11_14;
            String string5 = (String)item$iv$iv;
            collection = destination$iv$iv;
            void v0 = var11_14 = p1;
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)v0.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
            collection.add(string4);
        }
        collection = (List)destination$iv$iv;
        String routingKey = rabbitNamingStrategy.generateRoutingKey(string3, string2, string, (List<String>)collection);
        this.logger.info("Binding queue: '" + queueName + "' to exchange: '" + exchangeName + "' with routing key: '" + routingKey + "'");
        this.declareAndBindQueueFor(exchangeName, queueName, routingKey);
        this.logger.info("Subscribing operation: '" + operation.getName() + "' on queue: '" + queueName + "'");
        DefaultConsumer consumer2 = new DefaultConsumer(this, this.inboundChannel){
            final /* synthetic */ RabbitMessagingAdapter this$0;

            public void handleDelivery(@NotNull String consumerTag, @NotNull Envelope envelope, @NotNull AMQP.BasicProperties properties, @NotNull byte[] body) {
                Intrinsics.checkParameterIsNotNull((Object)consumerTag, (String)"consumerTag");
                Intrinsics.checkParameterIsNotNull((Object)envelope, (String)"envelope");
                Intrinsics.checkParameterIsNotNull((Object)properties, (String)"properties");
                Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
                try {
                    if (!RabbitMessagingAdapter.access$getMessageReceiver$p(this.this$0).isPresent()) {
                        throw (Throwable)new MissingMessageReceiverException();
                    }
                    ProtoMessage protoMessage = ProtoMessage.parseFrom(body);
                    Intrinsics.checkExpressionValueIsNotNull((Object)protoMessage, (String)"ProtoMessage.parseFrom(body)");
                    Message<Object> message = Message.Companion.fromProtobuf$riptide_core_java_main(protoMessage);
                    RabbitMessagingAdapter.access$getLogger$p(this.this$0).info("Message of type '" + message.getPayloadType$riptide_core_java_main() + "' is received from Rabbit. (" + message + ")");
                    ((MessageReceiver)RabbitMessagingAdapter.access$getMessageReceiver$p(this.this$0).get()).receive(message, this.this$0.fetchOperationFor(message));
                }
                catch (Exception e) {
                    String msg = "Failed to handle delivery of inbound message!" + (e.getMessage() != null ? " Reason: '" + e.getMessage() + "'" : "");
                    RabbitMessagingAdapter.access$getLogger$p(this.this$0).error(msg, (Throwable)e);
                    RabbitMessagingAdapter.access$getProcessEventService$p(this.this$0).sendProcessEvent(ProcessEvent.Companion.createFromException$riptide_core_java_main(e, msg));
                }
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        };
        this.inboundChannel.basicConsume(queueName, RabbitMessagingAdapter.Companion.getAUTO_ACK(), (Consumer)consumer2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OperationDescriptor fetchOperationFor(@NotNull Message<?> message) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        String group = message.getGroup();
        String version = message.getVersion();
        Class<?> payloadClass = message.getPayload().getClass();
        Iterable iterable = $receiver$iv = (Iterable)this.operations;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            OperationDescriptor op = (OperationDescriptor)element$iv$iv;
            if (!(Intrinsics.areEqual((Object)op.getGroupName(), (Object)group) & Intrinsics.areEqual((Object)op.getVersionName(), (Object)version) & Intrinsics.areEqual(op.getSourceClass(), payloadClass))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        int n = 0;
        if (n < 0 || n > CollectionsKt.getLastIndex((List)list)) {
            int it = n;
            throw (Throwable)new MissingOperationException("Can't find consumer/processor for Message with group: " + (group + ", version: " + version + " and class: " + payloadClass));
        }
        return (OperationDescriptor)list.get(n);
    }

    public final void setMessageReceiver(@NotNull MessageReceiver messageReceiver) {
        Intrinsics.checkParameterIsNotNull((Object)messageReceiver, (String)"messageReceiver");
        Optional<MessageReceiver> optional = Optional.of(messageReceiver);
        Intrinsics.checkExpressionValueIsNotNull(optional, (String)"Optional.of(messageReceiver)");
        this.messageReceiver = optional;
    }

    private final ConnectionFactory createConnectionFactory(RabbitConfig rabbitConfig) {
        ConnectionFactory factory = new ConnectionFactory();
        factory.setHost(rabbitConfig.getHost());
        factory.setPort(rabbitConfig.getPort());
        factory.setAutomaticRecoveryEnabled(true);
        return factory;
    }

    private final String declareExchangeFor(String operationName) {
        String exchangeName = this.rabbitNamingStrategy.generateExchangeName(operationName);
        this.logger.info("Generating exchange '{}' for operation '{}'.", (Object)exchangeName, (Object)operationName);
        boolean bl = RabbitMessagingAdapter.Companion.getAUTO_DELETE();
        boolean bl2 = RabbitMessagingAdapter.Companion.getDURABLE();
        BuiltinExchangeType builtinExchangeType = BuiltinExchangeType.TOPIC;
        String string = exchangeName;
        Channel channel = this.outboundChannel;
        Map map = MapsKt.emptyMap();
        channel.exchangeDeclare(string, builtinExchangeType, bl2, bl, map);
        return exchangeName;
    }

    private final String declareAndBindQueueFor(String exchangeName, String queueName, String routingKey) {
        boolean bl = RabbitMessagingAdapter.Companion.getAUTO_DELETE();
        boolean bl2 = RabbitMessagingAdapter.Companion.getEXCLUSIVE();
        boolean bl3 = RabbitMessagingAdapter.Companion.getDURABLE();
        String string = queueName;
        Channel channel = this.inboundChannel;
        Map map = MapsKt.emptyMap();
        channel.queueDeclare(string, bl3, bl2, bl, map);
        this.inboundChannel.queueBind(queueName, exchangeName, routingKey);
        return queueName;
    }

    public RabbitMessagingAdapter(@NotNull RabbitConfig rabbitConfig, @NotNull ProcessEventService processEventService, @NotNull RabbitNamingStrategy rabbitNamingStrategy) {
        Collection collection;
        Intrinsics.checkParameterIsNotNull((Object)rabbitConfig, (String)"rabbitConfig");
        Intrinsics.checkParameterIsNotNull((Object)processEventService, (String)"processEventService");
        Intrinsics.checkParameterIsNotNull((Object)rabbitNamingStrategy, (String)"rabbitNamingStrategy");
        this.processEventService = processEventService;
        this.rabbitNamingStrategy = rabbitNamingStrategy;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(javaClass)");
        this.logger = logger;
        RabbitMessagingAdapter rabbitMessagingAdapter = this;
        rabbitMessagingAdapter.knownExchanges = collection = (Set)new LinkedHashSet();
        rabbitMessagingAdapter = this;
        collection = new ArrayList();
        rabbitMessagingAdapter.operations = collection;
        Optional optional = Optional.empty();
        Intrinsics.checkExpressionValueIsNotNull(optional, (String)"Optional.empty()");
        this.messageReceiver = optional;
        ConnectionFactory factory = this.createConnectionFactory(rabbitConfig);
        Connection connection = factory.newConnection();
        Intrinsics.checkExpressionValueIsNotNull((Object)connection, (String)"factory.newConnection()");
        this.connection = connection;
        Channel channel = this.connection.createChannel();
        Intrinsics.checkExpressionValueIsNotNull((Object)channel, (String)"connection.createChannel()");
        this.inboundChannel = channel;
        Channel channel2 = this.connection.createChannel();
        Intrinsics.checkExpressionValueIsNotNull((Object)channel2, (String)"connection.createChannel()");
        this.outboundChannel = channel2;
    }

    public /* synthetic */ RabbitMessagingAdapter(RabbitConfig rabbitConfig, ProcessEventService processEventService, RabbitNamingStrategy rabbitNamingStrategy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            rabbitConfig = new RabbitConfig(null, 0, 3, null);
        }
        if ((n & 4) != 0) {
            rabbitNamingStrategy = new RabbitNamingStrategy(null, 1, null);
        }
        this(rabbitConfig, processEventService, rabbitNamingStrategy);
    }

    static {
        AUTO_DELETE = true;
        AUTO_ACK = true;
    }

    @NotNull
    public static final /* synthetic */ Optional access$getMessageReceiver$p(RabbitMessagingAdapter $this) {
        return $this.messageReceiver;
    }

    public static final /* synthetic */ void access$setMessageReceiver$p(RabbitMessagingAdapter $this, @NotNull Optional optional) {
        $this.messageReceiver = optional;
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLogger$p(RabbitMessagingAdapter $this) {
        return $this.logger;
    }

    @NotNull
    public static final /* synthetic */ ProcessEventService access$getProcessEventService$p(RabbitMessagingAdapter $this) {
        return $this.processEventService;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/codetome/riptide/core/adapter/rabbit/RabbitMessagingAdapter$Companion;", "", "()V", "AUTO_ACK", "", "getAUTO_ACK", "()Z", "AUTO_DELETE", "getAUTO_DELETE", "DURABLE", "getDURABLE", "EXCLUSIVE", "getEXCLUSIVE", "riptide.core.java_main"})
    public static final class Companion {
        private final boolean getDURABLE() {
            return DURABLE;
        }

        private final boolean getAUTO_DELETE() {
            return AUTO_DELETE;
        }

        private final boolean getEXCLUSIVE() {
            return EXCLUSIVE;
        }

        private final boolean getAUTO_ACK() {
            return AUTO_ACK;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

