/*
 * Decompiled with CFR 0.152.
 */
package org.codetome.riptide.core.adapter.rabbit;

import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.codetome.riptide.core.adapter.rabbit.RabbitNamingStrategy$WhenMappings;
import org.codetome.riptide.core.domain.Defaults;
import org.codetome.riptide.core.domain.OperationDescriptor;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rJ,\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/codetome/riptide/core/adapter/rabbit/RabbitNamingStrategy;", "", "uuidGeneratorFn", "Lkotlin/Function0;", "Ljava/util/UUID;", "(Lkotlin/jvm/functions/Function0;)V", "logger", "Lorg/slf4j/Logger;", "generateExchangeName", "", "operationName", "generateQueueName", "operation", "Lorg/codetome/riptide/core/domain/OperationDescriptor;", "generateRoutingKey", "groupName", "versionName", "customRoutingParams", "", "Companion", "riptide.core.java_main"})
public final class RabbitNamingStrategy {
    private final Logger logger;
    private final Function0<UUID> uuidGeneratorFn;
    private static final String VERSION_PLACEHOLDER = "{group}";
    private static final String GROUP_PLACEHOLDER = "{version}";
    private static final String OPERATION_PLACEHOLDER = "{operation}";
    private static final String UUID_PLACEHOLDER = "uuid";
    private static final String EXCHANGE_NAME_TEMPLATE = "v1.{operation}";
    private static final String WORKER_QUEUE_NAME_TEMPLATE = "v1.{operation}.worker";
    private static final String BROADCAST_QUEUE_NAME_TEMPLATE = "v1.{operation}.consumer.uuid";
    private static final String ROUTING_KEY_TEMPLATE = "{version}.{operation}.{group}";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String generateQueueName(@NotNull OperationDescriptor operation) {
        String string;
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        switch (RabbitNamingStrategy$WhenMappings.$EnumSwitchMapping$0[operation.getDispatchType().ordinal()]) {
            case 1: {
                String string3 = StringsKt.replace$default((String)RabbitNamingStrategy.Companion.getBROADCAST_QUEUE_NAME_TEMPLATE(), (String)RabbitNamingStrategy.Companion.getOPERATION_PLACEHOLDER(), (String)operation.getName(), (boolean)false, (int)4, null);
                String string4 = RabbitNamingStrategy.Companion.getUUID_PLACEHOLDER();
                String string5 = ((UUID)this.uuidGeneratorFn.invoke()).toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"uuidGeneratorFn().toString()");
                string2 = StringsKt.replace$default((String)string3, (String)string4, (String)string5, (boolean)false, (int)4, null);
                break;
            }
            case 2: {
                string2 = StringsKt.replace$default((String)RabbitNamingStrategy.Companion.getWORKER_QUEUE_NAME_TEMPLATE(), (String)RabbitNamingStrategy.Companion.getOPERATION_PLACEHOLDER(), (String)operation.getName(), (boolean)false, (int)4, null);
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Encountered unsupported dispatch type!");
            }
        }
        String string6 = string = string2;
        if (string6 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string7 = string6.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).toLowerCase()");
        String queueName = string7;
        this.logger.info("Generated queue name '" + queueName + "' for operation {name=" + operation.getName() + ", dispatchType=" + (Object)((Object)operation.getDispatchType()) + "}.");
        return queueName;
    }

    @NotNull
    public final String generateRoutingKey(@NotNull String groupName, @NotNull String versionName, @NotNull String operationName, @NotNull List<String> customRoutingParams) {
        Intrinsics.checkParameterIsNotNull((Object)groupName, (String)"groupName");
        Intrinsics.checkParameterIsNotNull((Object)versionName, (String)"versionName");
        Intrinsics.checkParameterIsNotNull((Object)operationName, (String)"operationName");
        Intrinsics.checkParameterIsNotNull(customRoutingParams, (String)"customRoutingParams");
        Object object = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)RabbitNamingStrategy.Companion.getROUTING_KEY_TEMPLATE(), (String)RabbitNamingStrategy.Companion.getGROUP_PLACEHOLDER(), (String)groupName, (boolean)false, (int)4, null), (String)RabbitNamingStrategy.Companion.getVERSION_PLACEHOLDER(), (String)versionName, (boolean)false, (int)4, null), (String)RabbitNamingStrategy.Companion.getOPERATION_PLACEHOLDER(), (String)operationName, (boolean)false, (int)4, null);
        String string = object;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        String routingKey = string2;
        object = customRoutingParams;
        if (!object.isEmpty()) {
            object = CollectionsKt.joinToString$default((Iterable)customRoutingParams, (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
            StringBuilder stringBuilder = new StringBuilder().append(routingKey + ".");
            Object object2 = object;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = ((String)object2).toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            String string4 = string3;
            routingKey = stringBuilder.append(string4).toString();
        }
        this.logger.info("Generated routing key '" + routingKey + "' for group '" + groupName + "', version '" + versionName + "' and operation '" + operationName + "'.");
        return routingKey;
    }

    @NotNull
    public final String generateExchangeName(@NotNull String operationName) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)operationName, (String)"operationName");
        String string2 = string = StringsKt.replace$default((String)RabbitNamingStrategy.Companion.getEXCHANGE_NAME_TEMPLATE(), (String)RabbitNamingStrategy.Companion.getOPERATION_PLACEHOLDER(), (String)operationName, (boolean)false, (int)4, null);
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String exchangeName = string3;
        this.logger.info("Generated exchange name '" + exchangeName + "' for operation name '" + operationName + "'.");
        return exchangeName;
    }

    public RabbitNamingStrategy(@NotNull Function0<UUID> uuidGeneratorFn) {
        Intrinsics.checkParameterIsNotNull(uuidGeneratorFn, (String)"uuidGeneratorFn");
        this.uuidGeneratorFn = uuidGeneratorFn;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(javaClass)");
        this.logger = logger;
    }

    public /* synthetic */ RabbitNamingStrategy(Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function0 = 1.INSTANCE;
        }
        this((Function0<UUID>)function0);
    }

    public RabbitNamingStrategy() {
        this(null, 1, null);
    }

    static {
        VERSION_PLACEHOLDER = VERSION_PLACEHOLDER;
        GROUP_PLACEHOLDER = GROUP_PLACEHOLDER;
        OPERATION_PLACEHOLDER = OPERATION_PLACEHOLDER;
        UUID_PLACEHOLDER = UUID_PLACEHOLDER;
        EXCHANGE_NAME_TEMPLATE = Defaults.Companion.getRABBIT_ADAPTER_VERSION() + "." + RabbitNamingStrategy.Companion.getOPERATION_PLACEHOLDER();
        WORKER_QUEUE_NAME_TEMPLATE = Defaults.Companion.getRABBIT_ADAPTER_VERSION() + "." + RabbitNamingStrategy.Companion.getOPERATION_PLACEHOLDER() + ".worker";
        BROADCAST_QUEUE_NAME_TEMPLATE = Defaults.Companion.getRABBIT_ADAPTER_VERSION() + "." + RabbitNamingStrategy.Companion.getOPERATION_PLACEHOLDER() + ".consumer." + RabbitNamingStrategy.Companion.getUUID_PLACEHOLDER();
        ROUTING_KEY_TEMPLATE = RabbitNamingStrategy.Companion.getGROUP_PLACEHOLDER() + "." + RabbitNamingStrategy.Companion.getOPERATION_PLACEHOLDER() + "." + RabbitNamingStrategy.Companion.getVERSION_PLACEHOLDER();
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0011\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0014\u0010\u0013\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lorg/codetome/riptide/core/adapter/rabbit/RabbitNamingStrategy$Companion;", "", "()V", "BROADCAST_QUEUE_NAME_TEMPLATE", "", "getBROADCAST_QUEUE_NAME_TEMPLATE", "()Ljava/lang/String;", "EXCHANGE_NAME_TEMPLATE", "getEXCHANGE_NAME_TEMPLATE", "GROUP_PLACEHOLDER", "getGROUP_PLACEHOLDER", "OPERATION_PLACEHOLDER", "getOPERATION_PLACEHOLDER", "ROUTING_KEY_TEMPLATE", "getROUTING_KEY_TEMPLATE", "UUID_PLACEHOLDER", "getUUID_PLACEHOLDER", "VERSION_PLACEHOLDER", "getVERSION_PLACEHOLDER", "WORKER_QUEUE_NAME_TEMPLATE", "getWORKER_QUEUE_NAME_TEMPLATE", "riptide.core.java_main"})
    public static final class Companion {
        private final String getVERSION_PLACEHOLDER() {
            return VERSION_PLACEHOLDER;
        }

        private final String getGROUP_PLACEHOLDER() {
            return GROUP_PLACEHOLDER;
        }

        private final String getOPERATION_PLACEHOLDER() {
            return OPERATION_PLACEHOLDER;
        }

        private final String getUUID_PLACEHOLDER() {
            return UUID_PLACEHOLDER;
        }

        private final String getEXCHANGE_NAME_TEMPLATE() {
            return EXCHANGE_NAME_TEMPLATE;
        }

        private final String getWORKER_QUEUE_NAME_TEMPLATE() {
            return WORKER_QUEUE_NAME_TEMPLATE;
        }

        private final String getBROADCAST_QUEUE_NAME_TEMPLATE() {
            return BROADCAST_QUEUE_NAME_TEMPLATE;
        }

        private final String getROUTING_KEY_TEMPLATE() {
            return ROUTING_KEY_TEMPLATE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

