/*
 * Decompiled with CFR 0.152.
 */
package org.codetome.riptide.core.api;

import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.codetome.riptide.core.adapter.rabbit.RabbitConfig;
import org.codetome.riptide.core.adapter.rabbit.RabbitMessagingAdapter;
import org.codetome.riptide.core.api.RiptideService;
import org.codetome.riptide.core.service.impl.MessagePublisherImpl;
import org.codetome.riptide.core.service.impl.MessageReceiverImpl;
import org.codetome.riptide.core.service.impl.ProcessEventServiceImpl;
import org.codetome.riptide.core.service.impl.RiptideServiceImpl;
import org.codetome.riptide.core.service.impl.SingleThreadDispatchMessageReceiver;
import org.codetome.riptide.core.service.messaging.MessagePublisher;
import org.codetome.riptide.core.service.messaging.MessageReceiver;
import org.codetome.riptide.core.service.messaging.MessagingAdapter;
import org.codetome.riptide.core.service.process.ProcessEventService;
import org.codetome.riptide.protobuf.ReservedOperations;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\u0003\u001a\u00020\u0000J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/codetome/riptide/core/api/RiptideServiceBuilder;", "", "()V", "dispatchProcessesOnSingleThread", "", "rabbitConfig", "Lorg/codetome/riptide/core/adapter/rabbit/RabbitConfig;", "build", "Lorg/codetome/riptide/core/api/RiptideService;", "useRabbit", "riptide.core.java_main"})
public final class RiptideServiceBuilder {
    private RabbitConfig rabbitConfig;
    private boolean dispatchProcessesOnSingleThread;

    @NotNull
    public final RiptideServiceBuilder dispatchProcessesOnSingleThread() {
        this.dispatchProcessesOnSingleThread = true;
        return this;
    }

    @NotNull
    public final RiptideServiceBuilder useRabbit(@NotNull RabbitConfig rabbitConfig) {
        Intrinsics.checkParameterIsNotNull((Object)rabbitConfig, (String)"rabbitConfig");
        this.rabbitConfig = rabbitConfig;
        return this;
    }

    @NotNull
    public final RiptideService build() {
        MessageReceiver messageReceiver;
        UUID instanceId = UUID.randomUUID();
        ProcessEventServiceImpl processService = new ProcessEventServiceImpl();
        RabbitConfig rabbitConfig = this.rabbitConfig;
        if (rabbitConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rabbitConfig");
        }
        RabbitMessagingAdapter messagingAdapter = new RabbitMessagingAdapter(rabbitConfig, processService, null, 4, null);
        MessagingAdapter messagingAdapter2 = messagingAdapter;
        UUID uUID = instanceId;
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"instanceId");
        MessagePublisherImpl messagePublisher = new MessagePublisherImpl(messagingAdapter2, uUID);
        if (this.dispatchProcessesOnSingleThread) {
            int n = 0;
            ProcessEventService processEventService = processService;
            MessagePublisher messagePublisher2 = messagePublisher;
            messageReceiver = new SingleThreadDispatchMessageReceiver(processEventService, messagePublisher2, n, 4, null);
        } else {
            messageReceiver = new MessageReceiverImpl(messagePublisher, processService);
        }
        MessageReceiver messageReceiver2 = messageReceiver;
        MessagePublisher messagePublisher3 = messagePublisher;
        Map map = MapsKt.mapOf((Pair)new Pair((Object)ReservedOperations.RT_DEFAULT_OP.name(), (Object)messageReceiver2));
        MessagingAdapter messagingAdapter3 = messagingAdapter;
        ProcessEventService processEventService = processService;
        UUID uUID2 = instanceId;
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID2, (String)"instanceId");
        RiptideServiceImpl service = new RiptideServiceImpl(messagePublisher3, map, messagingAdapter3, processEventService, uUID2);
        messagingAdapter.setMessageReceiver(service);
        return service;
    }
}

