/*
 * Decompiled with CFR 0.152.
 */
package org.codetome.riptide.core.service.impl;

import com.google.protobuf.MessageLite;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.codetome.riptide.core.api.OperationBuilder;
import org.codetome.riptide.core.domain.Message;
import org.codetome.riptide.core.service.messaging.MessagePublisher;
import org.codetome.riptide.core.service.messaging.MessagingAdapter;
import org.codetome.riptide.protobuf.PayloadKind;
import org.codetome.riptide.protobuf.ProcessState;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b2\u0006\u0010\u0011\u001a\u00020\rH\u0016J \u0010\u0012\u001a\u00020\u000f\"\b\b\u0000\u0010\u0013*\u00020\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0015H\u0002J \u0010\u0016\u001a\u00020\r\"\b\b\u0000\u0010\u0013*\u00020\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0015H\u0002J \u0010\u0017\u001a\u00020\u000f\"\b\b\u0000\u0010\u0013*\u00020\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0015H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/codetome/riptide/core/service/impl/MessagePublisherImpl;", "Lorg/codetome/riptide/core/service/messaging/MessagePublisher;", "messagingAdapter", "Lorg/codetome/riptide/core/service/messaging/MessagingAdapter;", "serviceInstanceId", "Ljava/util/UUID;", "(Lorg/codetome/riptide/core/service/messaging/MessagingAdapter;Ljava/util/UUID;)V", "logger", "Lorg/slf4j/Logger;", "operationOverrides", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/lang/Class;", "", "", "addOperationOverrideFor", "", "klass", "operationName", "checkPid", "T", "message", "Lorg/codetome/riptide/core/domain/Message;", "fetchOperationNameForMessage", "publish", "riptide.core.java_main"})
public final class MessagePublisherImpl
implements MessagePublisher {
    private final ConcurrentHashMap<Class<? extends Object>, String> operationOverrides;
    private final Logger logger;
    private final MessagingAdapter messagingAdapter;
    private final UUID serviceInstanceId;

    @Override
    public <T> void publish(@NotNull Message<T> message) {
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        this.checkPid(message);
        this.logger.info("Forwarding publishable message of type '" + message.getPayloadType$riptide_core_java_main() + "' to MessagingAdapter.");
        ProcessState processState = null;
        PayloadKind payloadKind = message.getPayload() instanceof MessageLite ? PayloadKind.PROTOBUF : PayloadKind.JSON;
        String string = this.fetchOperationNameForMessage(message);
        List list = null;
        UUID uUID = null;
        UUID uUID2 = this.serviceInstanceId;
        this.messagingAdapter.publish(Message.copy$default(message, null, null, null, null, string, uUID, list, uUID2, payloadKind, processState, 623, null));
    }

    @Override
    public void addOperationOverrideFor(@NotNull Class<? extends Object> klass, @NotNull String operationName) {
        Intrinsics.checkParameterIsNotNull(klass, (String)"klass");
        Intrinsics.checkParameterIsNotNull((Object)operationName, (String)"operationName");
        this.operationOverrides.put(klass, operationName);
    }

    private final <T> void checkPid(Message<T> message) {
        if (!message.hasPid$riptide_core_java_main()) {
            throw (Throwable)new IllegalArgumentException("Can't publish message with processMessages state '" + (Object)((Object)message.getProcessState$riptide_core_java_main()) + "' which has no pid (try using 'asProcessStart' if you want to start a processMessages)!");
        }
    }

    private final <T> String fetchOperationNameForMessage(Message<T> message) {
        String string;
        if (message.hasNoOperationNameDefined$riptide_core_java_main()) {
            String string2;
            Class<?> klass = message.getPayload().getClass();
            if (this.operationOverrides.containsKey(klass)) {
                String string3 = this.operationOverrides.get(klass);
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                string2 = string3;
            } else {
                string2 = OperationBuilder.Companion.generateOpNameFromSourceClass(klass);
            }
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"if (operationOverrides.c\u2026lass(klass)\n            }");
        } else {
            string = message.getOperation();
        }
        return string;
    }

    public MessagePublisherImpl(@NotNull MessagingAdapter messagingAdapter, @NotNull UUID serviceInstanceId) {
        Intrinsics.checkParameterIsNotNull((Object)messagingAdapter, (String)"messagingAdapter");
        Intrinsics.checkParameterIsNotNull((Object)serviceInstanceId, (String)"serviceInstanceId");
        this.messagingAdapter = messagingAdapter;
        this.serviceInstanceId = serviceInstanceId;
        this.operationOverrides = new ConcurrentHashMap();
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(javaClass)");
        this.logger = logger;
    }
}

