/*
 * Decompiled with CFR 0.152.
 */
package org.codetome.riptide.core.service.impl;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.codetome.riptide.core.api.exception.MissingNameException;
import org.codetome.riptide.core.domain.Message;
import org.codetome.riptide.core.domain.OperationDescriptor;
import org.codetome.riptide.core.domain.ProcessEvent;
import org.codetome.riptide.core.service.impl.MessageReceiverImpl$WhenMappings;
import org.codetome.riptide.core.service.messaging.MessagePublisher;
import org.codetome.riptide.core.service.messaging.MessageReceiver;
import org.codetome.riptide.core.service.process.ProcessEventService;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/codetome/riptide/core/service/impl/MessageReceiverImpl;", "Lorg/codetome/riptide/core/service/messaging/MessageReceiver;", "messagePublisher", "Lorg/codetome/riptide/core/service/messaging/MessagePublisher;", "processEventService", "Lorg/codetome/riptide/core/service/process/ProcessEventService;", "(Lorg/codetome/riptide/core/service/messaging/MessagePublisher;Lorg/codetome/riptide/core/service/process/ProcessEventService;)V", "logger", "Lorg/slf4j/Logger;", "receive", "", "message", "Lorg/codetome/riptide/core/domain/Message;", "", "operation", "Lorg/codetome/riptide/core/domain/OperationDescriptor;", "riptide.core.java_main"})
public final class MessageReceiverImpl
implements MessageReceiver {
    private final Logger logger;
    private final MessagePublisher messagePublisher;
    private final ProcessEventService processEventService;

    @Override
    public void receive(@NotNull Message<Object> message, @NotNull OperationDescriptor operation) {
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        switch (MessageReceiverImpl$WhenMappings.$EnumSwitchMapping$0[operation.getOperationType().ordinal()]) {
            case 1: {
                operation.getConsumerFn().invoke(message);
                break;
            }
            case 2: {
                this.messagePublisher.publish((Message)operation.getProcessorFn().invoke(message));
                break;
            }
            default: {
                String msg = "No operation found for received message: " + message + "!";
                this.logger.error(msg);
                this.processEventService.sendProcessEvent(ProcessEvent.Companion.createFromException$riptide_core_java_main(new MissingNameException(), msg));
            }
        }
    }

    public MessageReceiverImpl(@NotNull MessagePublisher messagePublisher, @NotNull ProcessEventService processEventService) {
        Intrinsics.checkParameterIsNotNull((Object)messagePublisher, (String)"messagePublisher");
        Intrinsics.checkParameterIsNotNull((Object)processEventService, (String)"processEventService");
        this.messagePublisher = messagePublisher;
        this.processEventService = processEventService;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(javaClass)");
        this.logger = logger;
    }
}

