/*
 * Decompiled with CFR 0.152.
 */
package org.codetome.riptide.core.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.codetome.riptide.core.api.ConsumerBuilder;
import org.codetome.riptide.core.api.ProcessEventListener;
import org.codetome.riptide.core.api.ProcessorBuilder;
import org.codetome.riptide.core.api.RiptideService;
import org.codetome.riptide.core.domain.Message;
import org.codetome.riptide.core.domain.OperationDescriptor;
import org.codetome.riptide.core.domain.ProcessEvent;
import org.codetome.riptide.core.service.messaging.MessagePublisher;
import org.codetome.riptide.core.service.messaging.MessageReceiver;
import org.codetome.riptide.core.service.messaging.MessagingAdapter;
import org.codetome.riptide.core.service.process.ProcessEventService;
import org.codetome.riptide.protobuf.ProcessState;
import org.codetome.riptide.protobuf.ReservedOperations;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B;\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ)\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016\"\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J!\u0010\u0019\u001a\u00020\u00122\u0017\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00120\u001b\u00a2\u0006\u0002\b\u001dH\u0016J4\u0010\u001e\u001a\u00020\u0012\"\b\b\u0000\u0010\u001f*\u00020 2\n\u0010!\u001a\u00060\"j\u0002`#2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H\u001f0%2\u0006\u0010&\u001a\u00020\u0006H\u0002J!\u0010'\u001a\u00020\u00122\u0017\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\u00120\u001b\u00a2\u0006\u0002\b\u001dH\u0016J \u0010)\u001a\u00020\u0012\"\b\b\u0000\u0010\u001f*\u00020 2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H\u001f0%H\u0016J\u001e\u0010*\u001a\u00020\u00122\f\u0010$\u001a\b\u0012\u0004\u0012\u00020 0%2\u0006\u0010+\u001a\u00020,H\u0016R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/codetome/riptide/core/service/impl/RiptideServiceImpl;", "Lorg/codetome/riptide/core/api/RiptideService;", "messagePublisher", "Lorg/codetome/riptide/core/service/messaging/MessagePublisher;", "messageReceivers", "", "", "Lorg/codetome/riptide/core/service/messaging/MessageReceiver;", "messagingAdapter", "Lorg/codetome/riptide/core/service/messaging/MessagingAdapter;", "processEventService", "Lorg/codetome/riptide/core/service/process/ProcessEventService;", "serviceInstanceId", "Ljava/util/UUID;", "(Lorg/codetome/riptide/core/service/messaging/MessagePublisher;Ljava/util/Map;Lorg/codetome/riptide/core/service/messaging/MessagingAdapter;Lorg/codetome/riptide/core/service/process/ProcessEventService;Ljava/util/UUID;)V", "logger", "Lorg/slf4j/Logger;", "addProcessListener", "", "listener", "Lorg/codetome/riptide/core/api/ProcessEventListener;", "processStates", "", "Lorg/codetome/riptide/protobuf/ProcessState;", "(Lorg/codetome/riptide/core/api/ProcessEventListener;[Lorg/codetome/riptide/protobuf/ProcessState;)V", "consumeMessages", "init", "Lkotlin/Function1;", "Lorg/codetome/riptide/core/api/ConsumerBuilder;", "Lkotlin/ExtensionFunctionType;", "handleProcessError", "T", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "Lorg/codetome/riptide/core/domain/Message;", "msg", "processMessages", "Lorg/codetome/riptide/core/api/ProcessorBuilder;", "publish", "receive", "operation", "Lorg/codetome/riptide/core/domain/OperationDescriptor;", "riptide.core.java_main"})
public final class RiptideServiceImpl
implements RiptideService {
    private final Logger logger;
    private final MessagePublisher messagePublisher;
    private final Map<String, MessageReceiver> messageReceivers;
    private final MessagingAdapter messagingAdapter;
    private final ProcessEventService processEventService;
    private final UUID serviceInstanceId;

    @Override
    public <T> void publish(@NotNull Message<T> message) {
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        try {
            this.logger.info("Forwarding message of type: '{}' to MessagePublisher.", (Object)message.getPayloadType$riptide_core_java_main());
            this.messagePublisher.publish(message);
        }
        catch (Exception e) {
            String msg = "Failed to publish message of type '" + message.getPayloadType$riptide_core_java_main() + "' to MessagePublisher. " + (e.getMessage() != null ? " Reason: " + e.getMessage() : "");
            this.logger.error(msg, (Throwable)e);
            this.handleProcessError(e, message, msg);
        }
    }

    @Override
    public void receive(@NotNull Message<Object> message, @NotNull OperationDescriptor operation) {
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        try {
            this.logger.info("Delegating message of type: '" + message.getPayloadType$riptide_core_java_main() + "' to receiver.");
            MessageReceiver messageReceiver = this.messageReceivers.get(ReservedOperations.RT_DEFAULT_OP.name());
            if (messageReceiver == null) {
                throw (Throwable)new IllegalStateException("No default receiver is present!");
            }
            MessageReceiver defaultReceiver = messageReceiver;
            this.messageReceivers.getOrDefault(message.getOperation(), defaultReceiver).receive(message, operation);
        }
        catch (Exception e) {
            String msg = "Failed to receive message of type '" + message.getPayloadType$riptide_core_java_main() + "'.";
            this.logger.error(msg);
            this.handleProcessError(e, message, msg);
        }
    }

    @Override
    public void consumeMessages(@NotNull Function1<? super ConsumerBuilder, Unit> init) {
        Intrinsics.checkParameterIsNotNull(init, (String)"init");
        ConsumerBuilder builder = new ConsumerBuilder();
        init.invoke((Object)builder);
        this.messagingAdapter.subscribe(builder.build());
    }

    @Override
    public void processMessages(@NotNull Function1<? super ProcessorBuilder, Unit> init) {
        Intrinsics.checkParameterIsNotNull(init, (String)"init");
        ProcessorBuilder builder = new ProcessorBuilder();
        init.invoke((Object)builder);
        OperationDescriptor od = builder.build();
        if (od.hasResultName()) {
            this.messagePublisher.addOperationOverrideFor(od.getResultClass(), od.getResultName());
        }
        this.messagingAdapter.subscribe(od);
    }

    @Override
    public void addProcessListener(@NotNull ProcessEventListener listener, ProcessState ... processStates) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Intrinsics.checkParameterIsNotNull((Object)processStates, (String)"processStates");
        this.processEventService.addProcessListener(listener, Arrays.copyOf(processStates, processStates.length));
    }

    private final <T> void handleProcessError(Exception e, Message<T> message, String msg) {
        List list = CollectionsKt.listOf((Object)e);
        ProcessState processState = ProcessState.ERRORED;
        String string = msg;
        UUID uUID = message.hasPid$riptide_core_java_main() ? message.getPid() : ProcessEvent.Companion.getUNKNOWN_PID();
        this.processEventService.sendProcessEvent(new ProcessEvent(string, processState, uUID, list));
    }

    public RiptideServiceImpl(@NotNull MessagePublisher messagePublisher, @NotNull Map<String, ? extends MessageReceiver> messageReceivers, @NotNull MessagingAdapter messagingAdapter, @NotNull ProcessEventService processEventService, @NotNull UUID serviceInstanceId) {
        Intrinsics.checkParameterIsNotNull((Object)messagePublisher, (String)"messagePublisher");
        Intrinsics.checkParameterIsNotNull(messageReceivers, (String)"messageReceivers");
        Intrinsics.checkParameterIsNotNull((Object)messagingAdapter, (String)"messagingAdapter");
        Intrinsics.checkParameterIsNotNull((Object)processEventService, (String)"processEventService");
        Intrinsics.checkParameterIsNotNull((Object)serviceInstanceId, (String)"serviceInstanceId");
        this.messagePublisher = messagePublisher;
        this.messageReceivers = messageReceivers;
        this.messagingAdapter = messagingAdapter;
        this.processEventService = processEventService;
        this.serviceInstanceId = serviceInstanceId;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(javaClass)");
        this.logger = logger;
    }
}

