/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.examples;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.cometd.Bayeux;
import org.cometd.Client;
import org.cometd.ClientListener;
import org.cometd.server.BayeuxService;
import org.cometd.server.ChannelImpl;
import org.eclipse.jetty.util.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChatService
extends BayeuxService {
    private final ConcurrentMap<String, Map<String, String>> _members = new ConcurrentHashMap();

    public ChatService(Bayeux bayeux) {
        super(bayeux, "chat");
        this.subscribe("/chat/**", "trackMembers");
        this.subscribe("/service/privatechat", "privateChat");
    }

    public void trackMembers(Client joiner, String channelName, Map<String, Object> data, String messageId) {
        if (Boolean.TRUE.equals(data.get("join"))) {
            ConcurrentHashMap<String, String> newMembersMap;
            ConcurrentHashMap<String, String> membersMap = (ConcurrentHashMap<String, String>)this._members.get(channelName);
            if (membersMap == null && (membersMap = (Map)this._members.putIfAbsent(channelName, newMembersMap = new ConcurrentHashMap<String, String>())) == null) {
                membersMap = newMembersMap;
            }
            ConcurrentHashMap<String, String> members = membersMap;
            String userName = (String)data.get("user");
            members.put(userName, joiner.getId());
            joiner.addListener((ClientListener)new /* Unavailable Anonymous Inner Class!! */);
            Log.info((String)("Members: " + members));
            this.getBayeux().getChannel(channelName, false).publish(this.getClient(), members.keySet(), messageId);
        }
    }

    public void privateChat(Client source, String channel, Map<String, Object> data, String messageId) {
        HashMap<String, Object> message;
        String roomName = (String)data.get("room");
        Map membersMap = (Map)this._members.get(roomName);
        String[] peerNames = ((String)data.get("peer")).split(",");
        ArrayList<Client> to = new ArrayList<Client>(peerNames.length);
        for (String peerName : peerNames) {
            Client peer;
            String peerId = (String)membersMap.get(peerName);
            if (peerId == null || (peer = this.getBayeux().getClient(peerId)) == null) continue;
            to.add(peer);
        }
        if (to.size() > 0) {
            message = new HashMap<String, Object>();
            message.put("chat", data.get("chat"));
            message.put("user", data.get("user"));
            message.put("scope", "private");
            ((ChannelImpl)this.getBayeux().getChannel(roomName, false)).deliver(this.getClient(), to, message, messageId);
            source.deliver(this.getClient(), roomName, message, messageId);
        } else if (!"silent".equals((String)data.get("peer"))) {
            message = new HashMap();
            message.put("chat", "Unknown user(s): " + data.get("peer"));
            message.put("user", "SERVER");
            message.put("scope", "error");
            source.deliver(source, roomName, message, messageId);
        }
    }
}

