/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.cometd.annotation.AnnotationProcessor;
import org.cometd.annotation.Configure;
import org.cometd.annotation.Listener;
import org.cometd.annotation.RemoteCall;
import org.cometd.annotation.Service;
import org.cometd.annotation.Session;
import org.cometd.annotation.Subscription;
import org.cometd.bayeux.ChannelId;
import org.cometd.bayeux.MarkedReference;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Promise;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerAnnotationProcessor
extends AnnotationProcessor {
    private final ConcurrentMap<Object, LocalSession> sessions = new ConcurrentHashMap<Object, LocalSession>();
    private final ConcurrentMap<Object, List<ListenerCallback>> listeners = new ConcurrentHashMap<Object, List<ListenerCallback>>();
    private final ConcurrentMap<Object, List<SubscriptionCallback>> subscribers = new ConcurrentHashMap<Object, List<SubscriptionCallback>>();
    private final ConcurrentMap<Object, List<RemoteCallCallback>> remoteCalls = new ConcurrentHashMap<Object, List<RemoteCallCallback>>();
    private final BayeuxServer bayeuxServer;
    private final Object[] injectables;

    public ServerAnnotationProcessor(BayeuxServer bayeuxServer) {
        this(bayeuxServer, new Object[0]);
    }

    public ServerAnnotationProcessor(BayeuxServer bayeuxServer, Object ... injectables) {
        this.bayeuxServer = bayeuxServer;
        this.injectables = injectables;
    }

    public boolean process(Object bean) {
        boolean result = this.processDependencies(bean);
        result |= this.processConfigurations(bean);
        result |= this.processCallbacks(bean);
        return result |= this.processPostConstruct(bean);
    }

    public boolean processConfigurations(Object bean) {
        if (bean == null) {
            return false;
        }
        Class<?> klass = bean.getClass();
        Service serviceAnnotation = klass.getAnnotation(Service.class);
        if (serviceAnnotation == null) {
            return false;
        }
        List<Method> methods = this.findAnnotatedMethods(bean, Configure.class);
        if (methods.isEmpty()) {
            return false;
        }
        for (Method method : methods) {
            String[] channels;
            Configure configure = method.getAnnotation(Configure.class);
            for (String channelName : channels = configure.value()) {
                ConfigurableServerChannel.Initializer init = channel -> {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Configure channel {} with method {} on bean {}", new Object[]{channel, method, bean});
                    }
                    this.invokePrivate(bean, method, channel);
                };
                MarkedReference initializedChannel = this.bayeuxServer.createChannelIfAbsent(channelName, new ConfigurableServerChannel.Initializer[]{init});
                if (initializedChannel.isMarked()) continue;
                if (configure.configureIfExists()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Configure again channel {} with method {} on bean {}", new Object[]{channelName, method, bean});
                    }
                    init.configureChannel((ConfigurableServerChannel)initializedChannel.getReference());
                    continue;
                }
                if (configure.errorIfExists()) {
                    throw new IllegalStateException("Channel already configured: " + channelName);
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Channel {} already initialized. Not called method {} on bean {}", new Object[]{channelName, method, bean});
            }
        }
        return true;
    }

    public boolean processDependencies(Object bean) {
        if (bean == null) {
            return false;
        }
        Class<?> klass = bean.getClass();
        Service serviceAnnotation = klass.getAnnotation(Service.class);
        if (serviceAnnotation == null) {
            return false;
        }
        ArrayList<Object> injectables = new ArrayList<Object>(Arrays.asList(this.injectables));
        injectables.add(0, this.bayeuxServer);
        boolean result = this.processInjectables(bean, injectables);
        LocalSession session = this.findOrCreateLocalSession(bean, serviceAnnotation.value());
        return result |= this.processSession(bean, session);
    }

    @Override
    public boolean processPostConstruct(Object bean) {
        return super.processPostConstruct(bean);
    }

    public boolean processCallbacks(Object bean) {
        if (bean == null) {
            return false;
        }
        Class<?> klass = bean.getClass();
        Service serviceAnnotation = klass.getAnnotation(Service.class);
        if (serviceAnnotation == null) {
            return false;
        }
        if (!Modifier.isPublic(klass.getModifiers())) {
            throw new IllegalArgumentException("Service class " + klass.getName() + " must be public");
        }
        LocalSession session = this.findOrCreateLocalSession(bean, serviceAnnotation.value());
        boolean result = this.processListener(bean, session);
        result |= this.processSubscription(bean, session);
        return result |= this.processRemoteCall(bean, session);
    }

    public boolean deprocess(Object bean) {
        boolean result = this.deprocessCallbacks(bean);
        return result |= this.processPreDestroy(bean);
    }

    public boolean deprocessCallbacks(Object bean) {
        if (bean == null) {
            return false;
        }
        Class<?> klass = bean.getClass();
        Service serviceAnnotation = klass.getAnnotation(Service.class);
        if (serviceAnnotation == null) {
            return false;
        }
        boolean result = this.deprocessListener(bean);
        result |= this.deprocessSubscription(bean);
        this.destroyLocalSession(bean);
        return result |= this.deprocessRemoteCall(bean);
    }

    private void destroyLocalSession(Object bean) {
        LocalSession session = (LocalSession)this.sessions.remove(bean);
        if (session != null) {
            session.disconnect();
        }
    }

    @Override
    public boolean processPreDestroy(Object bean) {
        return super.processPreDestroy(bean);
    }

    private LocalSession findOrCreateLocalSession(Object bean, String name) {
        LocalSession session = (LocalSession)this.sessions.get(bean);
        if (session == null) {
            session = this.bayeuxServer.newLocalSession(name);
            LocalSession existing = this.sessions.putIfAbsent(bean, session);
            if (existing != null) {
                session = existing;
            } else {
                session.handshake();
            }
        }
        return session;
    }

    private boolean processSession(Object bean, LocalSession localSession) {
        ServerSession serverSession = localSession.getServerSession();
        boolean result = false;
        for (Class<?> c = bean.getClass(); c != Object.class; c = c.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = c.getDeclaredFields()) {
                if (field.getAnnotation(Session.class) == null) continue;
                LocalSession value = null;
                if (field.getType().isAssignableFrom(localSession.getClass())) {
                    value = localSession;
                } else if (field.getType().isAssignableFrom(serverSession.getClass())) {
                    value = serverSession;
                }
                if (value == null) continue;
                this.setField(bean, field, value);
                result = true;
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Injected {} to field {} on bean {}", new Object[]{value, field, bean});
            }
        }
        List<Method> methods = this.findAnnotatedMethods(bean, Session.class);
        for (Method method : methods) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 1) continue;
            LocalSession value = null;
            if (parameterTypes[0].isAssignableFrom(localSession.getClass())) {
                value = localSession;
            } else if (parameterTypes[0].isAssignableFrom(serverSession.getClass())) {
                value = serverSession;
            }
            if (value == null) continue;
            this.invokePrivate(bean, method, value);
            result = true;
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("Injected {} to method {} on bean {}", new Object[]{value, method, bean});
        }
        return result;
    }

    private boolean processListener(Object bean, LocalSession localSession) {
        Method[] methods;
        ServerAnnotationProcessor.checkMethodsPublic(bean, Listener.class);
        boolean result = false;
        for (Method method : methods = bean.getClass().getMethods()) {
            String[] channels;
            Listener listener;
            if (method.getDeclaringClass() == Object.class || (listener = method.getAnnotation(Listener.class)) == null) continue;
            List<String> paramNames = this.processParameters(method);
            ServerAnnotationProcessor.checkSignaturesMatch(method, ListenerCallback.signature, paramNames);
            for (String channel : channels = listener.value()) {
                List existing;
                ChannelId channelId = new ChannelId(channel);
                if (channelId.isTemplate()) {
                    List parameters = channelId.getParameters();
                    if (parameters.size() != paramNames.size()) {
                        throw new IllegalArgumentException("Wrong number of template parameters in annotation @" + Listener.class.getSimpleName() + " on method " + method.getDeclaringClass().getName() + "." + method.getName() + "(...)");
                    }
                    if (!parameters.equals(paramNames)) {
                        throw new IllegalArgumentException("Wrong parameter names in annotation @" + Listener.class.getSimpleName() + " on method " + method.getDeclaringClass().getName() + "." + method.getName() + "(...)");
                    }
                    channel = channelId.getRegularPart() + "/" + (parameters.size() < 2 ? "*" : "**");
                }
                MarkedReference initializedChannel = this.bayeuxServer.createChannelIfAbsent(channel, new ConfigurableServerChannel.Initializer[0]);
                ListenerCallback listenerCallback = new ListenerCallback(localSession, bean, method, paramNames, channelId, channel, listener.receiveOwnPublishes());
                ((ServerChannel)initializedChannel.getReference()).addListener((ConfigurableServerChannel.ServerChannelListener)listenerCallback);
                List<ListenerCallback> callbacks = (CopyOnWriteArrayList<ListenerCallback>)this.listeners.get(bean);
                if (callbacks == null && (existing = (List)this.listeners.putIfAbsent(bean, callbacks = new CopyOnWriteArrayList<ListenerCallback>())) != null) {
                    callbacks = existing;
                }
                callbacks.add(listenerCallback);
                result = true;
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Registered listener for channel {} to method {} on bean {}", new Object[]{channel, method, bean});
            }
        }
        return result;
    }

    private boolean deprocessListener(Object bean) {
        boolean result = false;
        List callbacks = (List)this.listeners.remove(bean);
        if (callbacks != null) {
            for (ListenerCallback callback : callbacks) {
                ServerChannel channel = this.bayeuxServer.getChannel(callback.subscription);
                if (channel == null) continue;
                channel.removeListener((ConfigurableServerChannel.ServerChannelListener)callback);
                result = true;
            }
        }
        return result;
    }

    private boolean processSubscription(Object bean, LocalSession localSession) {
        Method[] methods;
        ServerAnnotationProcessor.checkMethodsPublic(bean, Subscription.class);
        boolean result = false;
        for (Method method : methods = bean.getClass().getMethods()) {
            String[] channels;
            Subscription subscription;
            if (method.getDeclaringClass() == Object.class || (subscription = method.getAnnotation(Subscription.class)) == null) continue;
            List<String> paramNames = this.processParameters(method);
            ServerAnnotationProcessor.checkSignaturesMatch(method, SubscriptionCallback.signature, paramNames);
            for (String channel : channels = subscription.value()) {
                List existing;
                if (ChannelId.isMeta((String)channel)) {
                    throw new IllegalArgumentException("Annotation @" + Subscription.class.getSimpleName() + " on method " + method.getDeclaringClass().getName() + "." + method.getName() + "(...) must specify a non meta channel");
                }
                ChannelId channelId = new ChannelId(channel);
                if (channelId.isTemplate()) {
                    List parameters = channelId.getParameters();
                    if (parameters.size() != paramNames.size()) {
                        throw new IllegalArgumentException("Wrong number of template parameters in annotation @" + Subscription.class.getSimpleName() + " on method " + method.getDeclaringClass().getName() + "." + method.getName() + "(...)");
                    }
                    if (!parameters.equals(paramNames)) {
                        throw new IllegalArgumentException("Wrong parameter names in annotation @" + Subscription.class.getSimpleName() + " on method " + method.getDeclaringClass().getName() + "." + method.getName() + "(...)");
                    }
                    channel = channelId.getRegularPart() + "/" + (parameters.size() < 2 ? "*" : "**");
                }
                SubscriptionCallback subscriptionCallback = new SubscriptionCallback(localSession, bean, method, paramNames, channelId, channel);
                localSession.getChannel(channel).subscribe((ClientSessionChannel.MessageListener)subscriptionCallback);
                List<SubscriptionCallback> callbacks = (CopyOnWriteArrayList<SubscriptionCallback>)this.subscribers.get(bean);
                if (callbacks == null && (existing = (List)this.subscribers.putIfAbsent(bean, callbacks = new CopyOnWriteArrayList<SubscriptionCallback>())) != null) {
                    callbacks = existing;
                }
                callbacks.add(subscriptionCallback);
                result = true;
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Registered subscriber for channel {} to method {} on bean {}", new Object[]{channel, method, bean});
            }
        }
        return result;
    }

    private boolean deprocessSubscription(Object bean) {
        boolean result = false;
        List callbacks = (List)this.subscribers.remove(bean);
        if (callbacks != null) {
            for (SubscriptionCallback callback : callbacks) {
                callback.localSession.getChannel(callback.subscription).unsubscribe((ClientSessionChannel.MessageListener)callback);
                result = true;
            }
        }
        return result;
    }

    private boolean processRemoteCall(Object bean, LocalSession localSession) {
        Method[] methods;
        ServerAnnotationProcessor.checkMethodsPublic(bean, RemoteCall.class);
        boolean result = false;
        for (Method method : methods = bean.getClass().getMethods()) {
            String[] targets;
            RemoteCall remoteCall = method.getAnnotation(RemoteCall.class);
            if (remoteCall == null) continue;
            List<String> paramNames = this.processParameters(method);
            ServerAnnotationProcessor.checkSignaturesMatch(method, RemoteCallCallback.signature, paramNames);
            for (String target : targets = remoteCall.value()) {
                List existing;
                String channel;
                ChannelId channelId;
                if (!target.startsWith("/")) {
                    target = "/" + target;
                }
                if ((channelId = new ChannelId(channel = "/service" + target)).isWild()) {
                    throw new IllegalArgumentException("Annotation @" + RemoteCall.class.getSimpleName() + " on method " + method.getDeclaringClass().getName() + "." + method.getName() + "(...) cannot specify wild channels.");
                }
                if (channelId.isTemplate()) {
                    List parameters = channelId.getParameters();
                    if (parameters.size() != paramNames.size()) {
                        throw new IllegalArgumentException("Wrong number of template parameters in annotation @" + RemoteCall.class.getSimpleName() + " on method " + method.getDeclaringClass().getName() + "." + method.getName() + "(...)");
                    }
                    if (!parameters.equals(paramNames)) {
                        throw new IllegalArgumentException("Wrong parameter names in annotation @" + RemoteCall.class.getSimpleName() + " on method " + method.getDeclaringClass().getName() + "." + method.getName() + "(...)");
                    }
                    channel = channelId.getRegularPart() + "/" + (parameters.size() < 2 ? "*" : "**");
                }
                MarkedReference initializedChannel = this.bayeuxServer.createChannelIfAbsent(channel, new ConfigurableServerChannel.Initializer[0]);
                RemoteCallCallback remoteCallCallback = new RemoteCallCallback(this.bayeuxServer, localSession, bean, method, paramNames, channelId, channel);
                ((ServerChannel)initializedChannel.getReference()).addListener((ConfigurableServerChannel.ServerChannelListener)remoteCallCallback);
                List<RemoteCallCallback> callbacks = (CopyOnWriteArrayList<RemoteCallCallback>)this.remoteCalls.get(bean);
                if (callbacks == null && (existing = (List)this.remoteCalls.putIfAbsent(bean, callbacks = new CopyOnWriteArrayList<RemoteCallCallback>())) != null) {
                    callbacks = existing;
                }
                callbacks.add(remoteCallCallback);
                result = true;
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Registered remote call for channel {} to method {} on bean {}", new Object[]{target, method, bean});
            }
        }
        return result;
    }

    private boolean deprocessRemoteCall(Object bean) {
        boolean result = false;
        List callbacks = (List)this.remoteCalls.remove(bean);
        if (callbacks != null) {
            for (RemoteCallCallback callback : callbacks) {
                ServerChannel channel = this.bayeuxServer.getChannel(callback.subscription);
                if (channel == null) continue;
                channel.removeListener((ConfigurableServerChannel.ServerChannelListener)callback);
                result = true;
            }
        }
        return result;
    }

    private static class ListenerCallback
    implements ServerChannel.MessageListener {
        private static final Class<?>[] signature = new Class[]{ServerSession.class, ServerMessage.Mutable.class};
        private final LocalSession localSession;
        private final Object target;
        private final Method method;
        private final ChannelId channelId;
        private final String subscription;
        private final boolean receiveOwnPublishes;
        private final List<String> paramNames;

        private ListenerCallback(LocalSession localSession, Object target, Method method, List<String> paramNames, ChannelId channelId, String subscription, boolean receiveOwnPublishes) {
            this.localSession = localSession;
            this.target = target;
            this.method = method;
            this.paramNames = paramNames;
            this.channelId = channelId;
            this.subscription = subscription;
            this.receiveOwnPublishes = receiveOwnPublishes;
        }

        public boolean onMessage(ServerSession from, ServerChannel channel, ServerMessage.Mutable message) {
            if (from == this.localSession.getServerSession() && !this.receiveOwnPublishes) {
                return true;
            }
            Map matches = this.channelId.bind(channel.getChannelId());
            if (!this.paramNames.isEmpty() && !matches.keySet().containsAll(this.paramNames)) {
                return true;
            }
            Object[] args = new Object[2 + this.paramNames.size()];
            args[0] = from;
            args[1] = message;
            for (int i = 0; i < this.paramNames.size(); ++i) {
                args[2 + i] = matches.get(this.paramNames.get(i));
            }
            return !Boolean.FALSE.equals(AnnotationProcessor.callPublic(this.target, this.method, args));
        }
    }

    private static class SubscriptionCallback
    implements ClientSessionChannel.MessageListener {
        private static final Class<?>[] signature = new Class[]{Message.class};
        private final LocalSession localSession;
        private final Object target;
        private final Method method;
        private final List<String> paramNames;
        private final ChannelId channelId;
        private final String subscription;

        public SubscriptionCallback(LocalSession localSession, Object target, Method method, List<String> paramNames, ChannelId channelId, String subscription) {
            this.localSession = localSession;
            this.target = target;
            this.method = method;
            this.paramNames = paramNames;
            this.channelId = channelId;
            this.subscription = subscription;
        }

        public void onMessage(ClientSessionChannel channel, Message message) {
            Map matches = this.channelId.bind(message.getChannelId());
            if (!this.paramNames.isEmpty() && !matches.keySet().containsAll(this.paramNames)) {
                return;
            }
            Object[] args = new Object[1 + this.paramNames.size()];
            args[0] = message;
            for (int i = 0; i < this.paramNames.size(); ++i) {
                args[1 + i] = matches.get(this.paramNames.get(i));
            }
            AnnotationProcessor.callPublic(this.target, this.method, args);
        }
    }

    private static class RemoteCallCallback
    implements ServerChannel.MessageListener {
        private static final Class<?>[] signature = new Class[]{RemoteCall.Caller.class, null};
        private final BayeuxServer bayeuxServer;
        private final LocalSession localSession;
        private final Object target;
        private final Method method;
        private final List<String> paramNames;
        private final ChannelId channelId;
        private final String subscription;

        private RemoteCallCallback(BayeuxServer bayeuxServer, LocalSession localSession, Object target, Method method, List<String> paramNames, ChannelId channelId, String subscription) {
            this.bayeuxServer = bayeuxServer;
            this.localSession = localSession;
            this.target = target;
            this.method = method;
            this.paramNames = paramNames;
            this.channelId = channelId;
            this.subscription = subscription;
        }

        public boolean onMessage(ServerSession from, ServerChannel channel, ServerMessage.Mutable message) {
            if (from == this.localSession.getServerSession()) {
                return true;
            }
            Map matches = this.channelId.bind(channel.getChannelId());
            if (!this.paramNames.isEmpty() && !matches.keySet().containsAll(this.paramNames)) {
                return true;
            }
            Object[] args = new Object[2 + this.paramNames.size()];
            CallerImpl caller = new CallerImpl(this.bayeuxServer, this.localSession, from, message.getId(), message.getChannel());
            args[0] = caller;
            args[1] = message.getData();
            for (int i = 0; i < this.paramNames.size(); ++i) {
                args[2 + i] = matches.get(this.paramNames.get(i));
            }
            try {
                return !Boolean.FALSE.equals(AnnotationProcessor.invokePublic(this.target, this.method, args));
            }
            catch (Throwable x) {
                HashMap<String, String> failure = new HashMap<String, String>();
                failure.put("class", x.getClass().getName());
                failure.put("message", x.getMessage());
                caller.failure(failure);
                Class<?> klass = this.target.getClass();
                Logger logger = LoggerFactory.getLogger(klass);
                logger.info("Exception while invoking " + klass + "#" + this.method.getName() + "()", x);
                return true;
            }
        }
    }

    private static class CallerImpl
    implements RemoteCall.Caller {
        private final AtomicBoolean complete = new AtomicBoolean();
        private final BayeuxServer bayeux;
        private final LocalSession sender;
        private final ServerSession session;
        private final String messageId;
        private final String channel;

        private CallerImpl(BayeuxServer bayeux, LocalSession sender, ServerSession session, String messageId, String channel) {
            this.bayeux = bayeux;
            this.sender = sender;
            this.session = session;
            this.messageId = messageId;
            this.channel = channel;
        }

        @Override
        public ServerSession getServerSession() {
            return this.session;
        }

        @Override
        public boolean result(Object result) {
            return this.deliver(result, true);
        }

        @Override
        public boolean failure(Object failure) {
            return this.deliver(failure, false);
        }

        private boolean deliver(Object data, boolean successful) {
            boolean completed = this.complete.compareAndSet(false, true);
            if (completed) {
                ServerMessage.Mutable message = this.bayeux.newMessage();
                message.setId(this.messageId);
                message.setSuccessful(successful);
                message.setChannel(this.channel);
                message.setData(data);
                this.session.deliver((org.cometd.bayeux.Session)this.sender, message, Promise.noop());
            }
            return completed;
        }
    }
}

