/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client.transport;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.cometd.bayeux.Message;
import org.cometd.client.BayeuxClient;
import org.cometd.client.transport.ClientTransport;
import org.cometd.client.transport.TransportListener;
import org.eclipse.jetty.client.ContentExchange;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.util.ajax.JSON;

public class LongPollingTransport
extends ClientTransport {
    private final HttpClient _httpClient;
    private volatile BayeuxClient _bayeuxClient;
    private volatile HttpURI _uri;

    public static LongPollingTransport create(Map<String, Object> options) {
        HttpClient httpClient = new HttpClient();
        httpClient.setIdleTimeout(5000L);
        httpClient.setConnectorType(2);
        httpClient.setMaxConnectionsPerAddress(32768);
        return LongPollingTransport.create(options, httpClient);
    }

    public static LongPollingTransport create(Map<String, Object> options, HttpClient httpClient) {
        LongPollingTransport transport = new LongPollingTransport(options, httpClient);
        if (!httpClient.isStarted()) {
            try {
                httpClient.start();
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        }
        return transport;
    }

    public LongPollingTransport(Map<String, Object> options, HttpClient httpClient) {
        super("long-polling", options);
        this._httpClient = httpClient;
    }

    @Override
    public boolean accept(String bayeuxVersion) {
        return true;
    }

    @Override
    public void init(BayeuxClient bayeux, HttpURI uri) {
        this._bayeuxClient = bayeux;
        this._uri = uri;
        super.init(bayeux, uri);
    }

    @Override
    public void send(TransportListener listener, Message.Mutable ... messages) {
        TransportExchange httpExchange = new TransportExchange(listener, (Message[])messages);
        httpExchange.setMethod("POST");
        if (messages.length == 1 && messages[0].isMeta()) {
            httpExchange.setURL(this._uri + messages[0].getChannel());
        } else {
            httpExchange.setURL(this._uri.toString());
        }
        String content = JSON.toString((Object[])messages);
        httpExchange.setRequestContentType("application/json;charset=UTF-8");
        try {
            httpExchange.setRequestContent((Buffer)new ByteArrayBuffer(content, "UTF-8"));
            if (this._bayeuxClient != null) {
                this._bayeuxClient.customize((HttpExchange)httpExchange);
            }
            this._httpClient.send((HttpExchange)httpExchange);
        }
        catch (Exception x) {
            listener.onException(x);
        }
    }

    @Override
    public void reset() {
    }

    private class TransportExchange
    extends ContentExchange {
        private final TransportListener _listener;
        private final Message[] _messages;

        private TransportExchange(TransportListener listener, Message ... messages) {
            super(true);
            this._listener = listener;
            this._messages = messages;
        }

        protected void onRequestCommitted() throws IOException {
            this._listener.onSending(this._messages);
        }

        protected void onResponseComplete() throws IOException {
            if (this.getResponseStatus() == 200) {
                String content = this.getResponseContent();
                if (content != null && content.length() > 0) {
                    List<Message.Mutable> messages = LongPollingTransport.this.toMessages(this.getResponseContent());
                    this._listener.onMessages(messages);
                } else {
                    this._listener.onProtocolError("Empty response: " + (Object)((Object)this));
                }
            } else {
                this._listener.onProtocolError("Unexpected response " + this.getResponseStatus() + ": " + (Object)((Object)this));
            }
        }

        protected void onConnectionFailed(Throwable x) {
            this._listener.onConnectException(x);
        }

        protected void onException(Throwable x) {
            this._listener.onException(x);
        }

        protected void onExpire() {
            this._listener.onExpire();
        }
    }
}

