/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.benchmark;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicStampedReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Atomics {
    public static void updateMin(AtomicLong currentMin, long newValue) {
        long oldValue = currentMin.get();
        while (newValue < oldValue && !currentMin.compareAndSet(oldValue, newValue)) {
            oldValue = currentMin.get();
        }
    }

    public static void updateMax(AtomicLong currentMax, long newValue) {
        long oldValue = currentMax.get();
        while (newValue > oldValue && !currentMax.compareAndSet(oldValue, newValue)) {
            oldValue = currentMax.get();
        }
    }

    public static void updateMin(AtomicInteger currentMin, int newValue) {
        int oldValue = currentMin.get();
        while (newValue < oldValue && !currentMin.compareAndSet(oldValue, newValue)) {
            oldValue = currentMin.get();
        }
    }

    public static void updateMax(AtomicInteger currentMax, int newValue) {
        int oldValue = currentMax.get();
        while (newValue > oldValue && !currentMax.compareAndSet(oldValue, newValue)) {
            oldValue = currentMax.get();
        }
    }

    public static <T> int decrement(AtomicStampedReference<T> reference) {
        int oldStamp = reference.getStamp();
        while (!reference.attemptStamp(reference.getReference(), oldStamp - 1)) {
            oldStamp = reference.getStamp();
        }
        return oldStamp - 1;
    }

    public static <T> boolean updateMax(AtomicStampedReference<T> reference, T value, int stamp) {
        int oldStamp = reference.getStamp();
        while (stamp > oldStamp) {
            if (reference.compareAndSet(reference.getReference(), value, oldStamp, stamp)) {
                return true;
            }
            oldStamp = reference.getStamp();
        }
        return false;
    }
}

