/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.ext;

import java.util.Map;
import java.util.Queue;
import org.cometd.Client;
import org.cometd.Extension;
import org.cometd.Message;
import org.cometd.server.MessageImpl;
import org.cometd.server.ext.ArrayIdQueue;

public class AcknowledgedMessagesClientExtension
implements Extension {
    private final Client _client;
    private final ArrayIdQueue<Message> _unackedQueue;
    private long _lastAck;

    public AcknowledgedMessagesClientExtension(Client client) {
        this._client = client;
        this._unackedQueue = new ArrayIdQueue(8, 16, client);
        this._unackedQueue.setCurrentId(1);
    }

    public Message rcv(Client from, Message message) {
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message rcvMeta(Client from, Message message) {
        if (message.getChannel().equals("/meta/connect")) {
            Client client = this._client;
            synchronized (client) {
                Long acked;
                Map ext = message.getExt(false);
                if (ext != null && (acked = (Long)ext.get("ack")) != null) {
                    int s = this._unackedQueue.size();
                    if (acked <= this._lastAck) {
                        Queue clientQueue = from.getQueue();
                        clientQueue.clear();
                        for (int i = 0; i < s; ++i) {
                            Message m = (Message)this._unackedQueue.getUnsafe(i);
                            if (m instanceof MessageImpl) {
                                ((MessageImpl)m).incRef();
                            }
                            clientQueue.add(m);
                        }
                    }
                    this._lastAck = acked;
                    if (s > 0) {
                        if (this._unackedQueue.getAssociatedIdUnsafe(s - 1) <= acked) {
                            for (int i = 0; i < s; ++i) {
                                Message q = (Message)this._unackedQueue.getUnsafe(i);
                                if (!(q instanceof MessageImpl)) continue;
                                ((MessageImpl)q).decRef();
                            }
                            this._unackedQueue.clear();
                        } else {
                            for (int i = 0; i < s && this._unackedQueue.getAssociatedIdUnsafe(0) <= acked; ++i) {
                                Message q = (Message)this._unackedQueue.remove();
                                if (!(q instanceof MessageImpl)) continue;
                                ((MessageImpl)q).decRef();
                            }
                        }
                    }
                }
            }
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message send(Client from, Message message) {
        Client client = this._client;
        synchronized (client) {
            this._unackedQueue.add(message);
            ((MessageImpl)message).incRef();
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message sendMeta(Client from, Message message) {
        if (message == null) {
            return message;
        }
        if (message.getChannel() == null) {
            return message;
        }
        if (message.getChannel().equals("/meta/connect")) {
            Client client = this._client;
            synchronized (client) {
                Map ext = message.getExt(true);
                ext.put("ack", this._unackedQueue.getCurrentId());
                this._unackedQueue.incrementCurrentId();
            }
        }
        return message;
    }
}

