/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.cometd.bayeux.ChannelId;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.Authorizer;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;
import org.eclipse.jetty.util.AttributesMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerChannelImpl
implements ServerChannel,
ConfigurableServerChannel {
    private final BayeuxServerImpl _bayeux;
    private final ChannelId _id;
    private final AttributesMap _attributes = new AttributesMap();
    private final Set<ServerSession> _subscribers = new CopyOnWriteArraySet<ServerSession>();
    private final List<ServerChannel.ServerChannelListener> _listeners = new CopyOnWriteArrayList<ServerChannel.ServerChannelListener>();
    private final List<Authorizer> _authorizers = new CopyOnWriteArrayList<Authorizer>();
    private final boolean _meta;
    private final boolean _broadcast;
    private final boolean _service;
    private final CountDownLatch _initialized;
    private boolean _lazy;
    private boolean _persistent;
    private volatile int _sweeperPasses = 0;

    protected ServerChannelImpl(BayeuxServerImpl bayeux, ChannelId id) {
        this._bayeux = bayeux;
        this._id = id;
        this._meta = this._id.isMeta();
        this._service = this._id.isService();
        this._broadcast = !this.isMeta() && !this.isService();
        this._initialized = new CountDownLatch(1);
        this.setPersistent(!this._broadcast);
    }

    void waitForInitialized() {
        try {
            if (!this._initialized.await(5L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("Not Initialized: " + this);
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Initizlization interrupted: " + this);
        }
    }

    void initialized() {
        this._initialized.countDown();
    }

    protected boolean subscribe(ServerSessionImpl session) {
        if (!session.isHandshook()) {
            return false;
        }
        if (this._subscribers.add(session)) {
            session.subscribedTo(this);
            for (ServerChannel.ServerChannelListener serverChannelListener : this._listeners) {
                if (!(serverChannelListener instanceof ServerChannel.SubscriptionListener)) continue;
                ((ServerChannel.SubscriptionListener)serverChannelListener).subscribed((ServerSession)session, (ServerChannel)this);
            }
            for (BayeuxServer.BayeuxServerListener bayeuxServerListener : this._bayeux.getListeners()) {
                if (!(bayeuxServerListener instanceof BayeuxServer.SubscriptionListener)) continue;
                ((BayeuxServer.SubscriptionListener)bayeuxServerListener).subscribed((ServerSession)session, (ServerChannel)this);
            }
        }
        this._sweeperPasses = 0;
        return true;
    }

    protected void unsubscribe(ServerSessionImpl session) {
        if (this._subscribers.remove(session)) {
            session.unsubscribedTo(this);
            for (ServerChannel.ServerChannelListener serverChannelListener : this._listeners) {
                if (!(serverChannelListener instanceof ServerChannel.SubscriptionListener)) continue;
                ((ServerChannel.SubscriptionListener)serverChannelListener).unsubscribed((ServerSession)session, (ServerChannel)this);
            }
            for (BayeuxServer.BayeuxServerListener bayeuxServerListener : this._bayeux.getListeners()) {
                if (!(bayeuxServerListener instanceof BayeuxServer.SubscriptionListener)) continue;
                ((BayeuxServer.SubscriptionListener)bayeuxServerListener).unsubscribed((ServerSession)session, (ServerChannel)this);
            }
        }
    }

    public Set<ServerSession> getSubscribers() {
        return Collections.unmodifiableSet(this._subscribers);
    }

    public boolean isBroadcast() {
        return this._broadcast;
    }

    public boolean isDeepWild() {
        return this._id.isDeepWild();
    }

    public boolean isLazy() {
        return this._lazy;
    }

    public boolean isPersistent() {
        return this._persistent;
    }

    public boolean isWild() {
        return this._id.isWild();
    }

    public void setLazy(boolean lazy) {
        this._lazy = lazy;
    }

    public void setPersistent(boolean persistent) {
        this._persistent = persistent;
    }

    public void addListener(ServerChannel.ServerChannelListener listener) {
        this._listeners.add(listener);
        this._sweeperPasses = 0;
    }

    public void removeListener(ServerChannel.ServerChannelListener listener) {
        this._listeners.remove(listener);
    }

    public List<ServerChannel.ServerChannelListener> getListeners() {
        return Collections.unmodifiableList(this._listeners);
    }

    public ChannelId getChannelId() {
        return this._id;
    }

    public String getId() {
        return this._id.toString();
    }

    public boolean isMeta() {
        return this._meta;
    }

    public boolean isService() {
        return this._service;
    }

    public void publish(Session from, ServerMessage.Mutable mutable) {
        ServerSessionImpl session;
        if (this.isWild()) {
            throw new IllegalStateException("Wild publish");
        }
        ServerSessionImpl serverSessionImpl = from instanceof ServerSessionImpl ? (ServerSessionImpl)from : (session = from instanceof LocalSession ? (ServerSessionImpl)((LocalSession)from).getServerSession() : null);
        if (this._bayeux.extendSend(session, null, mutable)) {
            this._bayeux.doPublish(session, this, mutable);
        }
    }

    public void publish(Session from, Object data, String id) {
        ServerMessage.Mutable mutable = this._bayeux.newMessage();
        mutable.setChannel(this.getId());
        if (from != null) {
            mutable.setClientId(from.getId());
        }
        mutable.setData(data);
        mutable.setId(id);
        this.publish(from, mutable);
    }

    protected void doSweep() {
        for (ServerSession session : this._subscribers) {
            if (session.isHandshook()) continue;
            this.unsubscribe((ServerSessionImpl)session);
        }
        if (this.isPersistent()) {
            return;
        }
        if (this._subscribers.size() > 0 || this._listeners.size() > 0) {
            return;
        }
        if (this.isWild() || this.isDeepWild()) {
            if (this._authorizers.size() > 0) {
                return;
            }
        } else {
            for (ServerChannel channel : this._bayeux.getChannels()) {
                if (!this._id.isParentOf(channel.getChannelId())) continue;
                return;
            }
        }
        if (++this._sweeperPasses < 3) {
            return;
        }
        this.remove();
    }

    public void remove() {
        for (ServerChannelImpl child : this._bayeux.getChannelChildren(this._id)) {
            child.remove();
        }
        if (this._bayeux.removeServerChannel(this)) {
            for (ServerSession subscriber : this._subscribers) {
                ((ServerSessionImpl)subscriber).unsubscribedTo(this);
            }
            this._subscribers.clear();
        }
        this._listeners.clear();
    }

    public void setAttribute(String name, Object value) {
        this._attributes.setAttribute(name, value);
    }

    public Object getAttribute(String name) {
        return this._attributes.getAttribute(name);
    }

    public Set<String> getAttributeNames() {
        return this._attributes.keySet();
    }

    public Object removeAttribute(String name) {
        Object old = this.getAttribute(name);
        this._attributes.removeAttribute(name);
        return old;
    }

    protected void dump(StringBuilder b, String indent) {
        b.append(this.toString());
        b.append(this.isLazy() ? " lazy" : "");
        b.append('\n');
        List<ServerChannelImpl> children = this._bayeux.getChannelChildren(this._id);
        int leaves = children.size() + this._subscribers.size() + this._listeners.size();
        int i = 0;
        for (ServerChannelImpl serverChannelImpl : children) {
            b.append(indent);
            b.append(" +-");
            serverChannelImpl.dump(b, indent + (++i == leaves ? "   " : " | "));
        }
        for (ServerSession serverSession : this._subscribers) {
            b.append(indent);
            b.append(" +-");
            ((ServerSessionImpl)serverSession).dump(b, indent + (++i == leaves ? "   " : " | "));
        }
        for (ServerChannel.ServerChannelListener serverChannelListener : this._listeners) {
            b.append(indent);
            b.append(" +-");
            b.append(serverChannelListener);
            b.append('\n');
        }
    }

    public void addAuthorizer(Authorizer authorizer) {
        this._authorizers.add(authorizer);
    }

    public void removeAuthorizer(Authorizer authorizer) {
        this._authorizers.remove(authorizer);
    }

    public List<Authorizer> getAuthorizers() {
        return Collections.unmodifiableList(this._authorizers);
    }

    public String toString() {
        return this._id.toString();
    }
}

