/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.ext;

import java.util.HashMap;
import java.util.Map;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.ext.AcknowledgedMessagesClientExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcknowledgedMessagesExtension
implements BayeuxServer.Extension {
    private final Logger _logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final Map<String, Object> _replyExt = new HashMap<String, Object>(1);

    public AcknowledgedMessagesExtension() {
        this._replyExt.put("ack", true);
    }

    public boolean rcv(ServerSession from, ServerMessage.Mutable message) {
        return true;
    }

    public boolean rcvMeta(ServerSession from, ServerMessage.Mutable message) {
        return true;
    }

    public boolean send(ServerSession from, ServerSession to, ServerMessage.Mutable message) {
        return true;
    }

    public boolean sendMeta(ServerSession to, ServerMessage.Mutable message) {
        String channel = message.getChannel();
        if (channel == null) {
            return true;
        }
        if ("/meta/handshake".equals(channel) && Boolean.TRUE.equals(message.get((Object)"successful"))) {
            Map mext;
            boolean clientRequestedAcks;
            ServerMessage.Mutable rcv = message.getAssociated();
            Map ext = rcv.getExt();
            boolean bl = clientRequestedAcks = ext != null && ext.get("ack") == Boolean.TRUE;
            if (clientRequestedAcks && to != null) {
                this._logger.info("Enabled message acknowledgement for client {}", (Object)to);
                to.addExtension((ServerSession.Extension)new AcknowledgedMessagesClientExtension(to));
                ((ServerSessionImpl)to).setMetaConnectDeliveryOnly(true);
            }
            if ((mext = message.getExt()) != null) {
                mext.put("ack", Boolean.TRUE);
            } else {
                message.put((Object)"ext", this._replyExt);
            }
        }
        return true;
    }
}

