/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.cometd.bayeux.ChannelId;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.client.ClientSession;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.common.AbstractClientSession;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalSessionImpl
extends AbstractClientSession
implements LocalSession {
    private final Queue<ServerMessage.Mutable> _queue = new ConcurrentLinkedQueue<ServerMessage.Mutable>();
    private final BayeuxServerImpl _bayeux;
    private final String _idHint;
    private ServerSessionImpl _session;

    protected LocalSessionImpl(BayeuxServerImpl bayeux, String idHint) {
        this._bayeux = bayeux;
        this._idHint = idHint;
    }

    public void receive(Message.Mutable message) {
        super.receive(message);
        if ("/meta/disconnect".equals(message.getChannel()) && message.isSuccessful()) {
            this._session = null;
        }
    }

    protected AbstractClientSession.AbstractSessionChannel newChannel(ChannelId channelId) {
        return new LocalChannel(channelId);
    }

    protected ChannelId newChannelId(String channelId) {
        return this._bayeux.newChannelId(channelId);
    }

    protected void sendBatch() {
        int size = this._queue.size();
        while (size-- > 0) {
            ServerMessage.Mutable message = this._queue.poll();
            this.doSend(this._session, message);
        }
    }

    public ServerSession getServerSession() {
        if (this._session == null) {
            throw new IllegalStateException("Method handshake() not invoked for local session " + (Object)((Object)this));
        }
        return this._session;
    }

    public void handshake() {
        this.handshake(null);
    }

    public void handshake(Map<String, Object> template) {
        if (this._session != null) {
            throw new IllegalStateException();
        }
        ServerMessage.Mutable message = this._bayeux.newMessage();
        if (template != null) {
            message.putAll(template);
        }
        message.setChannel("/meta/handshake");
        message.setId(this.newMessageId());
        ServerSessionImpl session = new ServerSessionImpl(this._bayeux, this, this._idHint);
        this.doSend(session, message);
        ServerMessage.Mutable reply = message.getAssociated();
        if (reply != null && reply.isSuccessful()) {
            this._session = session;
            message = this._bayeux.newMessage();
            message.setChannel("/meta/connect");
            message.setClientId(this._session.getId());
            message.getAdvice(true).put("interval", -1L);
            message.setId(this.newMessageId());
            this.doSend(session, message);
            reply = message.getAssociated();
            if (!reply.isSuccessful()) {
                this._session = null;
            }
        }
        message.setAssociated(null);
    }

    public void disconnect() {
        if (this._session != null) {
            ServerMessage.Mutable message = this._bayeux.newMessage();
            message.setChannel("/meta/disconnect");
            message.setId(this.newMessageId());
            this.send(this._session, message);
            while (this.isBatching()) {
                this.endBatch();
            }
        }
    }

    public String getId() {
        if (this._session == null) {
            throw new IllegalStateException("Method handshake() not invoked for local session " + (Object)((Object)this));
        }
        return this._session.getId();
    }

    public boolean isConnected() {
        return this._session != null && this._session.isConnected();
    }

    public boolean isHandshook() {
        return this._session != null && this._session.isHandshook();
    }

    public String toString() {
        return "L:" + (this._session == null ? this._idHint + "?" : this._session.getId());
    }

    protected void send(ServerSessionImpl session, ServerMessage.Mutable message) {
        if (this.isBatching()) {
            this._queue.add(message);
        } else {
            this.doSend(session, message);
        }
    }

    protected void doSend(ServerSessionImpl from, ServerMessage.Mutable message) {
        ServerMessage.Mutable reply;
        if (!this.extendSend((Message.Mutable)message)) {
            return;
        }
        if (this._session != null) {
            message.setClientId(this._session.getId());
        }
        if ((reply = this._bayeux.handle(from, message)) != null && (reply = this._bayeux.extendReply(from, this._session != null && this._session.isHandshook() ? this._session : null, reply)) != null) {
            this.receive((Message.Mutable)reply);
        }
    }

    protected class LocalChannel
    extends AbstractClientSession.AbstractSessionChannel {
        LocalChannel(ChannelId id) {
            super((AbstractClientSession)LocalSessionImpl.this, id);
        }

        public ClientSession getSession() {
            this.throwIfReleased();
            return LocalSessionImpl.this;
        }

        public void publish(Object data) {
            this.publish(data, null);
        }

        public void publish(Object data, String messageId) {
            this.throwIfReleased();
            if (LocalSessionImpl.this._session == null) {
                throw new IllegalStateException("Method handshake() not invoked for local session " + (Object)((Object)this));
            }
            ServerMessage.Mutable message = LocalSessionImpl.this._bayeux.newMessage();
            message.setChannel(this.getId());
            message.setData(data);
            if (messageId != null) {
                message.setId(messageId);
            }
            LocalSessionImpl.this.send(LocalSessionImpl.this._session, message);
            message.setAssociated(null);
        }

        public String toString() {
            return super.toString() + "@" + LocalSessionImpl.this.toString();
        }

        protected void sendSubscribe() {
            ServerMessage.Mutable message = LocalSessionImpl.this._bayeux.newMessage();
            message.setChannel("/meta/subscribe");
            message.put((Object)"subscription", (Object)this.getId());
            message.setClientId(LocalSessionImpl.this.getId());
            message.setId(LocalSessionImpl.this.newMessageId());
            LocalSessionImpl.this.send(LocalSessionImpl.this._session, message);
            message.setAssociated(null);
        }

        protected void sendUnSubscribe() {
            ServerMessage.Mutable message = LocalSessionImpl.this._bayeux.newMessage();
            message.setChannel("/meta/unsubscribe");
            message.put((Object)"subscription", (Object)this.getId());
            message.setId(LocalSessionImpl.this.newMessageId());
            LocalSessionImpl.this.send(LocalSessionImpl.this._session, message);
            message.setAssociated(null);
        }
    }
}

