/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.transport;

import java.io.IOException;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.List;
import javax.servlet.AsyncContext;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.transport.AbstractHttpTransport;
import org.eclipse.jetty.util.Utf8StringBuilder;

public class AsyncJSONTransport
extends AbstractHttpTransport {
    private static final String PREFIX = "long-polling.json";
    private static final String NAME = "long-polling";

    public AsyncJSONTransport(BayeuxServerImpl bayeux) {
        super(bayeux, NAME);
        this.setOptionPrefix(PREFIX);
    }

    @Override
    public boolean accept(HttpServletRequest request) {
        return "POST".equalsIgnoreCase(request.getMethod());
    }

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String encoding = request.getCharacterEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        request.setCharacterEncoding(encoding);
        AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
        asyncContext.setTimeout(0L);
        Charset charset = Charset.forName(encoding);
        AbstractReader reader = "UTF-8".equals(charset.name()) ? new UTF8Reader(request, response, asyncContext) : new CharsetReader(request, response, asyncContext, charset);
        ServletInputStream input = request.getInputStream();
        input.setReadListener((ReadListener)reader);
    }

    @Override
    protected AbstractHttpTransport.HttpScheduler suspend(HttpServletRequest request, HttpServletResponse response, ServerSessionImpl session, ServerMessage.Mutable reply, String browserId, long timeout) {
        AsyncContext asyncContext = request.getAsyncContext();
        return this.newHttpScheduler(request, response, asyncContext, session, reply, browserId, timeout);
    }

    protected AbstractHttpTransport.HttpScheduler newHttpScheduler(HttpServletRequest request, HttpServletResponse response, AsyncContext asyncContext, ServerSessionImpl session, ServerMessage.Mutable reply, String browserId, long timeout) {
        return new AsyncLongPollScheduler(request, response, asyncContext, session, reply, browserId, timeout);
    }

    @Override
    protected void write(HttpServletRequest request, HttpServletResponse response, ServerSessionImpl session, boolean startInterval, List<ServerMessage> messages, ServerMessage.Mutable[] replies) {
        AsyncContext asyncContext = request.getAsyncContext();
        try {
            response.setContentType("application/json;charset=UTF-8");
            ServletOutputStream output = response.getOutputStream();
            output.setWriteListener((WriteListener)new Writer(request, response, asyncContext, session, startInterval, messages, replies));
        }
        catch (Exception x) {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Exception while writing messages", (Throwable)x);
            }
            this.error(request, response, asyncContext, 500);
        }
    }

    private class AsyncLongPollScheduler
    extends AbstractHttpTransport.LongPollScheduler {
        private AsyncLongPollScheduler(HttpServletRequest request, HttpServletResponse response, AsyncContext asyncContext, ServerSessionImpl session, ServerMessage.Mutable reply, String browserId, long timeout) {
            super(AsyncJSONTransport.this, request, response, asyncContext, session, reply, browserId, timeout);
        }

        @Override
        protected void dispatch() {
            AsyncJSONTransport.this.resume(this.getRequest(), this.getResponse(), this.getAsyncContext(), this.getServerSession(), this.getMetaConnectReply());
        }

        @Override
        protected void error(int code) {
            AsyncJSONTransport.this.error(this.getRequest(), this.getResponse(), this.getAsyncContext(), code);
        }
    }

    protected class Writer
    implements WriteListener {
        private final StringBuilder buffer = new StringBuilder(512);
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private final AsyncContext asyncContext;
        private final ServerSessionImpl session;
        private final boolean startInterval;
        private final List<ServerMessage> messages;
        private final ServerMessage.Mutable[] replies;
        private int messageIndex = -1;
        private int replyIndex;

        protected Writer(HttpServletRequest request, HttpServletResponse response, AsyncContext asyncContext, ServerSessionImpl session, boolean startInterval, List<ServerMessage> messages, ServerMessage.Mutable[] replies) {
            this.request = request;
            this.response = response;
            this.asyncContext = asyncContext;
            this.session = session;
            this.startInterval = startInterval;
            this.messages = messages;
            this.replies = replies;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onWritePossible() throws IOException {
            boolean needsComma;
            ServletOutputStream output;
            try {
                output = this.response.getOutputStream();
                if (this.messageIndex < 0) {
                    this.messageIndex = 0;
                    this.buffer.append("[");
                }
                if (AsyncJSONTransport.this._logger.isDebugEnabled()) {
                    AsyncJSONTransport.this._logger.debug("Messages to write for session {}: {}", (Object)this.session, (Object)this.messages.size());
                }
                while (this.messageIndex < this.messages.size()) {
                    if (this.messageIndex > 0) {
                        this.buffer.append(",");
                    }
                    this.buffer.append(this.messages.get(this.messageIndex++).getJSON());
                    output.write(this.buffer.toString().getBytes("UTF-8"));
                    this.buffer.setLength(0);
                    if (output.isReady()) continue;
                    return;
                }
            }
            finally {
                if (this.replyIndex == 0 && this.startInterval && this.session != null && this.session.isConnected()) {
                    this.session.startIntervalTimeout(AsyncJSONTransport.this.getInterval());
                }
            }
            if (AsyncJSONTransport.this._logger.isDebugEnabled()) {
                AsyncJSONTransport.this._logger.debug("Replies to write for session {}: {}", (Object)this.session, (Object)this.replies.length);
            }
            boolean bl = needsComma = this.messageIndex > 0;
            while (this.replyIndex < this.replies.length) {
                ServerMessage.Mutable reply;
                if ((reply = this.replies[this.replyIndex++]) == null) continue;
                if (needsComma) {
                    this.buffer.append(",");
                }
                needsComma = true;
                this.buffer.append(reply.getJSON());
                if (this.replyIndex == this.replies.length) {
                    this.buffer.append("]");
                }
                output.write(this.buffer.toString().getBytes("UTF-8"));
                this.buffer.setLength(0);
                if (output.isReady()) continue;
                return;
            }
            this.asyncContext.complete();
        }

        public void onError(Throwable throwable) {
            AsyncJSONTransport.this.error(this.request, this.response, this.asyncContext, 500);
        }
    }

    protected class CharsetReader
    extends AbstractReader {
        private byte[] content;
        private final Charset charset;
        private int count;

        public CharsetReader(HttpServletRequest request, HttpServletResponse response, AsyncContext asyncContext, Charset charset) {
            super(request, response, asyncContext);
            this.content = new byte[512];
            this.charset = charset;
        }

        @Override
        protected void append(byte[] buffer, int offset, int length) {
            int size;
            int newSize = size = this.content.length;
            while (newSize - this.count < length) {
                newSize <<= 1;
            }
            if (newSize < 0) {
                throw new IllegalArgumentException("Message too large");
            }
            if (newSize != size) {
                byte[] newContent = new byte[newSize];
                System.arraycopy(this.content, 0, newContent, 0, this.count);
                this.content = newContent;
            }
            System.arraycopy(buffer, offset, this.content, this.count, length);
            this.count += length;
        }

        @Override
        protected String finish() {
            return new String(this.content, 0, this.count, this.charset);
        }
    }

    protected class UTF8Reader
    extends AbstractReader {
        private final Utf8StringBuilder content;

        protected UTF8Reader(HttpServletRequest request, HttpServletResponse response, AsyncContext asyncContext) {
            super(request, response, asyncContext);
            this.content = new Utf8StringBuilder(512);
        }

        @Override
        protected void append(byte[] buffer, int offset, int length) {
            this.content.append(buffer, offset, length);
        }

        @Override
        protected String finish() {
            return this.content.toString();
        }
    }

    protected abstract class AbstractReader
    implements ReadListener {
        protected static final int CAPACITY = 512;
        private final byte[] buffer = new byte[512];
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        protected final AsyncContext asyncContext;

        protected AbstractReader(HttpServletRequest request, HttpServletResponse response, AsyncContext asyncContext) {
            this.request = request;
            this.response = response;
            this.asyncContext = asyncContext;
        }

        public void onDataAvailable() throws IOException {
            ServletInputStream input = this.request.getInputStream();
            if (AsyncJSONTransport.this._logger.isDebugEnabled()) {
                AsyncJSONTransport.this._logger.debug("Asynchronous read start from {}", (Object)input);
            }
            while (input.isReady() && !input.isFinished()) {
                int read = input.read(this.buffer);
                if (AsyncJSONTransport.this._logger.isDebugEnabled()) {
                    AsyncJSONTransport.this._logger.debug("Asynchronous read {} bytes from {}", (Object)read, (Object)input);
                }
                if (read < 0) continue;
                this.append(this.buffer, 0, read);
            }
            if (!input.isFinished() && AsyncJSONTransport.this._logger.isDebugEnabled()) {
                AsyncJSONTransport.this._logger.debug("Asynchronous read pending from {}", (Object)input);
            }
        }

        protected abstract void append(byte[] var1, int var2, int var3);

        public void onAllDataRead() throws IOException {
            ServletInputStream input = this.request.getInputStream();
            String json = this.finish();
            if (AsyncJSONTransport.this._logger.isDebugEnabled()) {
                AsyncJSONTransport.this._logger.debug("Asynchronous read end from {}: {}", (Object)input, (Object)json);
            }
            this.process(json);
        }

        protected abstract String finish();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void process(String json) throws IOException {
            AsyncJSONTransport.this.getBayeux().setCurrentTransport(AsyncJSONTransport.this);
            AsyncJSONTransport.this.setCurrentRequest(this.request);
            try {
                ServerMessage.Mutable[] messages = AsyncJSONTransport.this.parseMessages(json);
                if (AsyncJSONTransport.this._logger.isDebugEnabled()) {
                    AsyncJSONTransport.this._logger.debug("Parsed {} messages", (Object)messages.length);
                }
                AsyncJSONTransport.this.processMessages(this.request, this.response, messages);
            }
            catch (ParseException x) {
                AsyncJSONTransport.this.handleJSONParseException(this.request, this.response, json, x);
                this.asyncContext.complete();
            }
            finally {
                AsyncJSONTransport.this.setCurrentRequest(null);
                AsyncJSONTransport.this.getBayeux().setCurrentTransport(null);
            }
        }

        public void onError(Throwable throwable) {
            AsyncJSONTransport.this.error(this.request, this.response, this.asyncContext, 500);
        }
    }
}

