/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.filter;

import java.lang.reflect.Array;
import java.util.regex.Pattern;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.filter.DataFilter;
import org.cometd.server.filter.JSONDataFilter;

public class RegexFilter
extends JSONDataFilter {
    protected String[] _templates;
    protected String[] _replaces;
    protected Pattern[] _patterns;

    @Override
    public void init(Object init) {
        int i;
        super.init(init);
        this._templates = new String[Array.getLength(init)];
        this._replaces = new String[this._templates.length];
        for (i = 0; i < this._templates.length; ++i) {
            Object entry = Array.get(init, i);
            this._templates[i] = (String)Array.get(entry, 0);
            this._replaces[i] = (String)Array.get(entry, 1);
        }
        this._patterns = new Pattern[this._templates.length];
        for (i = 0; i < this._patterns.length; ++i) {
            this._patterns[i] = Pattern.compile(this._templates[i]);
        }
    }

    @Override
    protected Object filterString(ServerSession session, ServerChannel channel, String string) {
        for (int i = 0; i < this._patterns.length; ++i) {
            if (this._replaces[i] != null) {
                string = this._patterns[i].matcher(string).replaceAll(this._replaces[i]);
                continue;
            }
            if (!this._patterns[i].matcher(string).matches()) continue;
            throw new DataFilter.AbortException("matched " + this._patterns[i] + " in " + string);
        }
        return string;
    }
}

