/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.transport;

import java.io.IOException;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.List;
import java.util.concurrent.TimeoutException;
import javax.servlet.AsyncContext;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cometd.bayeux.Promise;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.transport.AbstractHttpTransport;
import org.eclipse.jetty.util.Utf8StringBuilder;

public class AsyncJSONTransport
extends AbstractHttpTransport {
    private static final String PREFIX = "long-polling.json";
    private static final String NAME = "long-polling";
    private static final int BUFFER_CAPACITY = 512;
    private static final ThreadLocal<byte[]> buffers = ThreadLocal.withInitial(() -> new byte[512]);

    public AsyncJSONTransport(BayeuxServerImpl bayeux) {
        super(bayeux, NAME);
        this.setOptionPrefix(PREFIX);
    }

    @Override
    public boolean accept(HttpServletRequest request) {
        return "POST".equalsIgnoreCase(request.getMethod());
    }

    @Override
    public void handle(final HttpServletRequest request, final HttpServletResponse response) throws IOException, ServletException {
        String encoding = request.getCharacterEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        request.setCharacterEncoding(encoding);
        final AsyncContext asyncContext = request.startAsync();
        asyncContext.setTimeout(0L);
        Promise<Void> promise = new Promise<Void>(){

            public void succeed(Void result) {
                asyncContext.complete();
                if (AsyncJSONTransport.this._logger.isDebugEnabled()) {
                    AsyncJSONTransport.this._logger.debug("Handling successful");
                }
            }

            public void fail(Throwable failure) {
                request.setAttribute("javax.servlet.error.exception", (Object)failure);
                int code = failure instanceof TimeoutException ? 408 : 500;
                AsyncJSONTransport.this.sendError(request, response, code, failure);
                asyncContext.complete();
                if (AsyncJSONTransport.this._logger.isDebugEnabled()) {
                    AsyncJSONTransport.this._logger.debug("Handling failed", failure);
                }
            }
        };
        AbstractHttpTransport.Context context = new AbstractHttpTransport.Context(request, response);
        Charset charset = Charset.forName(encoding);
        AbstractReader reader = "UTF-8".equals(charset.name()) ? new UTF8Reader(context, promise) : new CharsetReader(context, promise, charset);
        ServletInputStream input = request.getInputStream();
        input.setReadListener((ReadListener)reader);
    }

    protected void process(String json, AbstractHttpTransport.Context context, Promise<Void> promise) {
        block6: {
            try {
                try {
                    ServerMessage.Mutable[] messages = this.parseMessages(json);
                    if (this._logger.isDebugEnabled()) {
                        this._logger.debug("Parsed {} messages", (Object)(messages == null ? -1 : messages.length));
                    }
                    if (messages != null) {
                        this.processMessages(context, messages, promise);
                        break block6;
                    }
                    promise.succeed(null);
                }
                catch (ParseException x) {
                    this.handleJSONParseException(context.request, context.response, json, x);
                    promise.succeed(null);
                }
            }
            catch (Throwable x) {
                promise.fail(x);
            }
        }
    }

    @Override
    protected AbstractHttpTransport.HttpScheduler suspend(AbstractHttpTransport.Context context, Promise<Void> promise, ServerMessage.Mutable message, long timeout) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Suspended {}", (Object)message);
        }
        context.scheduler = this.newHttpScheduler(context, promise, message, timeout);
        context.session.notifySuspended((ServerMessage)message, timeout);
        return context.scheduler;
    }

    protected AbstractHttpTransport.HttpScheduler newHttpScheduler(AbstractHttpTransport.Context context, Promise<Void> promise, ServerMessage.Mutable reply, long timeout) {
        return new AsyncLongPollScheduler(context, promise, reply, timeout);
    }

    @Override
    protected void write(AbstractHttpTransport.Context context, List<ServerMessage> messages, Promise<Void> promise) {
        HttpServletResponse response = context.response;
        try {
            response.setContentType("application/json;charset=UTF-8");
            ServletOutputStream output = response.getOutputStream();
            output.setWriteListener((WriteListener)new Writer(context, messages, promise));
        }
        catch (Throwable x) {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Exception while writing messages", x);
            }
            promise.fail(x);
        }
    }

    protected void writeComplete(AbstractHttpTransport.Context context, List<ServerMessage> messages) {
    }

    private class AsyncLongPollScheduler
    extends AbstractHttpTransport.LongPollScheduler {
        private AsyncLongPollScheduler(AbstractHttpTransport.Context context, Promise<Void> promise, ServerMessage.Mutable reply, long timeout) {
            super(AsyncJSONTransport.this, context, promise, reply, timeout);
        }

        @Override
        protected void dispatch(boolean timeout) {
            this.getContext().session.notifyResumed((ServerMessage)this.getMessage(), timeout);
            this.getPromise().succeed(null);
        }
    }

    private static enum State {
        BEGIN,
        HANDSHAKE,
        MESSAGES,
        REPLIES,
        END,
        COMPLETE;

    }

    protected class Writer
    implements WriteListener {
        private final AbstractHttpTransport.Context context;
        private final List<ServerMessage> messages;
        private final Promise<Void> promise;
        private int messageIndex;
        private int replyIndex;
        private boolean needsComma;
        private State state = State.BEGIN;

        protected Writer(AbstractHttpTransport.Context context, List<ServerMessage> messages, Promise<Void> promise) {
            this.context = context;
            this.messages = messages;
            this.promise = promise;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onWritePossible() throws IOException {
            ServletOutputStream output = this.context.response.getOutputStream();
            if (AsyncJSONTransport.this._logger.isDebugEnabled()) {
                AsyncJSONTransport.this._logger.debug("Messages/replies {}/{} to write for session {}", new Object[]{this.messages.size(), this.context.replies.size(), this.context.session});
            }
            block8: while (true) {
                switch (this.state) {
                    case BEGIN: {
                        this.state = State.HANDSHAKE;
                        if (this.writeBegin(output)) continue block8;
                        return;
                    }
                    case HANDSHAKE: {
                        this.state = State.MESSAGES;
                        if (this.writeHandshakeReply(output)) continue block8;
                        return;
                    }
                    case MESSAGES: {
                        if (!this.writeMessages(output)) {
                            return;
                        }
                        this.state = State.REPLIES;
                        continue block8;
                    }
                    case REPLIES: {
                        if (!this.writeReplies(output)) {
                            return;
                        }
                        this.state = State.END;
                        continue block8;
                    }
                    case END: {
                        this.state = State.COMPLETE;
                        if (!this.writeEnd(output)) return;
                        continue block8;
                    }
                    case COMPLETE: {
                        this.promise.succeed(null);
                        AsyncJSONTransport.this.writeComplete(this.context, this.messages);
                        return;
                    }
                }
                break;
            }
            throw new IllegalStateException();
        }

        private boolean writeBegin(ServletOutputStream output) throws IOException {
            output.write(91);
            return output.isReady();
        }

        private boolean writeHandshakeReply(ServletOutputStream output) throws IOException {
            ServerMessage.Mutable reply;
            List<ServerMessage.Mutable> replies = this.context.replies;
            if (replies.size() > 0 && "/meta/handshake".equals((reply = replies.get(0)).getChannel())) {
                if (AsyncJSONTransport.this.allowMessageDeliveryDuringHandshake(this.context.session) && !this.messages.isEmpty()) {
                    reply.put((Object)"x-messages", (Object)this.messages.size());
                }
                AsyncJSONTransport.this.getBayeux().freeze(reply);
                output.write(AsyncJSONTransport.this.toJSONBytes((ServerMessage)reply, "UTF-8"));
                this.needsComma = true;
                ++this.replyIndex;
            }
            return output.isReady();
        }

        private boolean writeMessages(ServletOutputStream output) throws IOException {
            try {
                int size = this.messages.size();
                while (output.isReady()) {
                    if (this.messageIndex == size) {
                        this.startExpiration();
                        return true;
                    }
                    if (this.needsComma) {
                        output.write(44);
                        this.needsComma = false;
                        continue;
                    }
                    ServerMessage message = this.messages.get(this.messageIndex);
                    output.write(AsyncJSONTransport.this.toJSONBytes(message, "UTF-8"));
                    this.needsComma = this.messageIndex < size;
                    ++this.messageIndex;
                }
                return false;
            }
            catch (Throwable x) {
                this.startExpiration();
                throw x;
            }
        }

        private void startExpiration() {
            ServerSessionImpl session = this.context.session;
            if (this.context.scheduleExpiration && session != null && (session.isHandshook() || session.isConnected())) {
                session.scheduleExpiration(AsyncJSONTransport.this.getInterval());
            }
        }

        private boolean writeReplies(ServletOutputStream output) throws IOException {
            List<ServerMessage.Mutable> replies = this.context.replies;
            int size = replies.size();
            while (output.isReady()) {
                if (this.replyIndex == size) {
                    return true;
                }
                ServerMessage.Mutable reply = replies.get(this.replyIndex);
                if (reply != null) {
                    if (this.needsComma) {
                        output.write(44);
                        this.needsComma = false;
                        continue;
                    }
                    AsyncJSONTransport.this.getBayeux().freeze(reply);
                    output.write(AsyncJSONTransport.this.toJSONBytes((ServerMessage)reply, "UTF-8"));
                    this.needsComma = this.replyIndex < size;
                    ++this.replyIndex;
                    continue;
                }
                ++this.replyIndex;
            }
            return false;
        }

        private boolean writeEnd(ServletOutputStream output) throws IOException {
            output.write(93);
            return output.isReady();
        }

        public void onError(Throwable failure) {
            if (AsyncJSONTransport.this._logger.isDebugEnabled()) {
                AsyncJSONTransport.this._logger.debug("Failure writing messages", failure);
            }
            this.startExpiration();
            this.promise.fail(failure);
        }
    }

    protected class CharsetReader
    extends AbstractReader {
        private byte[] content;
        private final Charset charset;
        private int count;

        public CharsetReader(AbstractHttpTransport.Context context, Promise<Void> promise, Charset charset) {
            super(context, promise);
            this.content = new byte[512];
            this.charset = charset;
        }

        @Override
        protected void append(byte[] buffer, int offset, int length) {
            int size;
            int newSize = size = this.content.length;
            while (newSize - this.count < length) {
                newSize <<= 1;
            }
            if (newSize < 0) {
                throw new IllegalArgumentException("Message too large");
            }
            if (newSize != size) {
                byte[] newContent = new byte[newSize];
                System.arraycopy(this.content, 0, newContent, 0, this.count);
                this.content = newContent;
            }
            System.arraycopy(buffer, offset, this.content, this.count, length);
            this.count += length;
        }

        @Override
        protected String finish() {
            return new String(this.content, 0, this.count, this.charset);
        }
    }

    protected class UTF8Reader
    extends AbstractReader {
        private final Utf8StringBuilder content;

        protected UTF8Reader(AbstractHttpTransport.Context context, Promise<Void> promise) {
            super(context, promise);
            this.content = new Utf8StringBuilder(512);
        }

        @Override
        protected void append(byte[] buffer, int offset, int length) {
            this.content.append(buffer, offset, length);
        }

        @Override
        protected String finish() {
            return this.content.toString();
        }
    }

    protected abstract class AbstractReader
    implements ReadListener {
        private final AbstractHttpTransport.Context context;
        private final Promise<Void> promise;
        private int total;

        protected AbstractReader(AbstractHttpTransport.Context context, Promise<Void> promise) {
            this.context = context;
            this.promise = promise;
        }

        public void onDataAvailable() throws IOException {
            ServletInputStream input = this.context.request.getInputStream();
            if (AsyncJSONTransport.this._logger.isDebugEnabled()) {
                AsyncJSONTransport.this._logger.debug("Asynchronous read start from {}", (Object)input);
            }
            int maxMessageSize = AsyncJSONTransport.this.getMaxMessageSize();
            byte[] buffer = (byte[])buffers.get();
            while (input.isReady()) {
                int read = input.read(buffer);
                if (AsyncJSONTransport.this._logger.isDebugEnabled()) {
                    AsyncJSONTransport.this._logger.debug("Asynchronous read {} bytes from {}", (Object)read, (Object)input);
                }
                if (read < 0) break;
                if (maxMessageSize > 0) {
                    this.total += read;
                    if (this.total > maxMessageSize) {
                        throw new IOException("Max message size " + maxMessageSize + " exceeded");
                    }
                }
                this.append(buffer, 0, read);
            }
            if (!input.isFinished() && AsyncJSONTransport.this._logger.isDebugEnabled()) {
                AsyncJSONTransport.this._logger.debug("Asynchronous read pending from {}", (Object)input);
            }
        }

        protected abstract void append(byte[] var1, int var2, int var3);

        public void onAllDataRead() throws IOException {
            ServletInputStream input = this.context.request.getInputStream();
            String json = this.finish();
            if (AsyncJSONTransport.this._logger.isDebugEnabled()) {
                AsyncJSONTransport.this._logger.debug("Asynchronous read end from {}: {}", (Object)input, (Object)json);
            }
            AsyncJSONTransport.this.process(json, this.context, this.promise);
        }

        protected abstract String finish();

        public void onError(Throwable failure) {
            this.promise.fail(failure);
        }
    }
}

