/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.rstModules;

import de.hu_berlin.german.korpling.rst.Group;
import de.hu_berlin.german.korpling.rst.RSTDocument;
import de.hu_berlin.german.korpling.rst.Segment;
import de.hu_berlin.german.korpling.rst.resources.RSTResourceFactory;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.peppermodules.rstModules.RSTImporterProperties;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDominanceRelation;
import org.corpus_tools.salt.common.SStructure;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.common.tokenizer.SimpleTokenizer;
import org.corpus_tools.salt.common.tokenizer.Tokenizer;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class RST2SaltMapper
extends PepperMapperImpl
implements PepperMapper {
    private ResourceSet resourceSet = null;
    private RSTDocument currentRSTDocument = null;
    private Hashtable<String, SStructure> rstId2SStructure = null;
    private Tokenizer tokenizer = null;
    public static final String NODE_KIND_SEGMENT = "segment";
    public static final String NODE_KIND_GROUP = "group";

    public RST2SaltMapper() {
        this.init();
    }

    private void init() {
        this.tokenizer = new Tokenizer();
        this.rstId2SStructure = new Hashtable();
    }

    public void setResourceSet(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    public ResourceSet getResourceSet() {
        if (this.resourceSet == null) {
            this.resourceSet = new ResourceSetImpl();
            this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("rs3", new RSTResourceFactory());
        }
        return this.resourceSet;
    }

    public void setCurrentRSTDocument(RSTDocument currentRSTDocument) {
        this.currentRSTDocument = currentRSTDocument;
    }

    public RSTDocument getCurrentRSTDocument() {
        return this.currentRSTDocument;
    }

    public DOCUMENT_STATUS mapSDocument() {
        Resource resource = this.getResourceSet().createResource(this.getResourceURI());
        if (resource == null) {
            throw new PepperModuleException((PepperMapper)this, "Cannot load the RST file: " + this.getResourceURI() + ", becuase the resource is null.");
        }
        try {
            resource.load(null);
        }
        catch (IOException e) {
            throw new PepperModuleException((PepperMapper)this, "Cannot load the RST file: " + this.getResourceURI() + ".", (Throwable)e);
        }
        RSTDocument rstDocument = null;
        rstDocument = (RSTDocument)resource.getContents().get(0);
        this.mapSDocument(rstDocument);
        return DOCUMENT_STATUS.COMPLETED;
    }

    public void mapSDocument(RSTDocument rstDocument) {
        if (this.getDocument().getDocumentGraph() == null) {
            this.getDocument().setDocumentGraph(SaltFactory.createSDocumentGraph());
        }
        this.setCurrentRSTDocument(rstDocument);
        if (this.getCurrentRSTDocument().getSegments().size() > 0) {
            if (((RSTImporterProperties)this.getProperties()).isToTokenize().booleanValue()) {
                this.mapSegmentsWithTokenize((List<Segment>)this.getCurrentRSTDocument().getSegments());
            } else {
                this.mapSegmentsWithoutTokenize((List<Segment>)this.getCurrentRSTDocument().getSegments());
            }
        }
        for (Group group : this.getCurrentRSTDocument().getGroups()) {
            this.mapGroup2SStructure(group);
        }
        for (de.hu_berlin.german.korpling.rst.Relation relation : this.getCurrentRSTDocument().getRelations()) {
            this.mapRelation(relation);
        }
    }

    public Tokenizer getTokenizer() {
        return this.tokenizer;
    }

    public void mapSegmentsWithTokenize(List<Segment> segments) {
        STextualDS sText = null;
        if (segments != null && segments.size() > 0) {
            sText = SaltFactory.createSTextualDS();
            this.getDocument().getDocumentGraph().addNode((Node)sText);
            for (Segment segment : segments) {
                SimpleTokenizer tokenizer;
                List tokens = null;
                int start = 0;
                if (sText.getText() != null) {
                    start = sText.getText().length();
                    sText.setText(sText.getText() + ((RSTImporterProperties)this.getProperties()).getSegmentSeparator() + segment.getText());
                } else {
                    sText.setText(segment.getText());
                }
                int end = sText.getText().length();
                if (((RSTImporterProperties)this.getProperties()).getSimpleTokenizationSeparators() != null) {
                    tokenizer = new SimpleTokenizer();
                    tokenizer.setDocumentGraph(this.getDocument().getDocumentGraph());
                    Character[] seps = (Character[])((RSTImporterProperties)this.getProperties()).getSimpleTokenizationSeparators().toArray();
                    tokenizer.tokenize(sText, seps);
                } else {
                    tokenizer = this.getDocument().getDocumentGraph().createTokenizer();
                    tokens = tokenizer.tokenize(sText, null, Integer.valueOf(start), Integer.valueOf(end));
                }
                if (tokens == null || tokens.size() <= 0) continue;
                SStructure sStruct = SaltFactory.createSStructure();
                sStruct.setName(segment.getId());
                sStruct.createAnnotation(null, ((RSTImporterProperties)this.getProperties()).getNodeKindName(), (Object)NODE_KIND_SEGMENT);
                if (segment.getType() != null) {
                    sStruct.createAnnotation(null, ((RSTImporterProperties)this.getProperties()).getNodeTypeName(), (Object)segment.getType());
                }
                this.rstId2SStructure.put(segment.getId(), sStruct);
                this.getDocument().getDocumentGraph().addNode((Node)sStruct);
                for (SToken sToken : tokens) {
                    SDominanceRelation sDomRel = SaltFactory.createSDominanceRelation();
                    sDomRel.setSource((Node)sStruct);
                    sDomRel.setTarget((Node)sToken);
                    this.getDocument().getDocumentGraph().addRelation((Relation)sDomRel);
                }
            }
        }
    }

    private void mapSegmentsWithoutTokenize(List<Segment> segments) {
        STextualDS sText = null;
        if (segments != null && segments.size() > 0) {
            sText = SaltFactory.createSTextualDS();
            this.getDocument().getDocumentGraph().addNode((Node)sText);
            StringBuffer strBuffer = new StringBuffer();
            int i = 0;
            for (Segment segment : segments) {
                ++i;
                SStructure sStruct = SaltFactory.createSStructure();
                sStruct.createAnnotation(null, ((RSTImporterProperties)this.getProperties()).getNodeKindName(), (Object)NODE_KIND_SEGMENT);
                if (segment.getType() != null) {
                    sStruct.createAnnotation(null, ((RSTImporterProperties)this.getProperties()).getNodeTypeName(), (Object)segment.getType());
                }
                sStruct.setName(segment.getId());
                this.rstId2SStructure.put(segment.getId(), sStruct);
                this.getDocument().getDocumentGraph().addNode((Node)sStruct);
                SToken sToken = SaltFactory.createSToken();
                this.getDocument().getDocumentGraph().addNode((Node)sToken);
                STextualRelation sTextRel = SaltFactory.createSTextualRelation();
                sTextRel.setTarget((Node)sText);
                sTextRel.setSource((Node)sToken);
                sTextRel.setStart((Number)strBuffer.length());
                sTextRel.setEnd((Number)(strBuffer.length() + segment.getText().length()));
                this.getDocument().getDocumentGraph().addRelation((Relation)sTextRel);
                SDominanceRelation sDomRel = SaltFactory.createSDominanceRelation();
                sDomRel.setSource((Node)sStruct);
                sDomRel.setTarget((Node)sToken);
                this.getDocument().getDocumentGraph().addRelation((Relation)sDomRel);
                if (i != 0) {
                    strBuffer.append(((RSTImporterProperties)this.getProperties()).getSegmentSeparator());
                }
                strBuffer.append(segment.getText());
            }
            sText.setText(strBuffer.toString());
        }
    }

    private SStructure mapGroup2SStructure(Group group) {
        SStructure sStructure = null;
        if (group != null) {
            sStructure = SaltFactory.createSStructure();
            sStructure.setName(group.getId());
            if (group.getType() != null) {
                sStructure.createAnnotation(null, ((RSTImporterProperties)this.getProperties()).getNodeTypeName(), (Object)group.getType());
            }
            this.rstId2SStructure.put(group.getId(), sStructure);
            SAnnotation sAnno = SaltFactory.createSAnnotation();
            sAnno.setName(((RSTImporterProperties)this.getProperties()).getNodeKindName());
            sAnno.setValue((Object)NODE_KIND_GROUP);
            sStructure.addAnnotation(sAnno);
            this.getDocument().getDocumentGraph().addNode((Node)sStructure);
        }
        return sStructure;
    }

    private void mapRelation(de.hu_berlin.german.korpling.rst.Relation relation) {
        if (relation != null) {
            if (relation.getParent() == null) {
                throw new PepperModuleException((PepperMapper)this, "Cannot map the rst-model of file'" + this.getResourceURI() + "', because the parent of a relation is empty.");
            }
            if (relation.getParent() == null) {
                throw new PepperModuleException((PepperMapper)this, "Cannot map the rst-model of file'" + this.getResourceURI() + "', because the source of a relation is empty.");
            }
            SStructure sSource = this.rstId2SStructure.get(relation.getParent().getId());
            SStructure sTarget = this.rstId2SStructure.get(relation.getChild().getId());
            if (sSource == null) {
                throw new PepperModuleException((PepperMapper)this, "Cannot map the rst-model of file'" + this.getResourceURI() + "', because the parent of a relation points to a non existing node with id '" + relation.getChild().getId() + "'.");
            }
            if (sTarget == null) {
                throw new PepperModuleException((PepperMapper)this, "Cannot map the rst-model of file'" + this.getResourceURI() + "', because the parent of a relation belongs to a non existing node with id '" + relation.getParent().getId() + "'.");
            }
            SDominanceRelation sDomRel = SaltFactory.createSDominanceRelation();
            if (relation.getType() != null) {
                sDomRel.setType(relation.getType());
            }
            sDomRel.setSource((Node)sSource);
            sDomRel.setTarget((Node)sTarget);
            this.getDocument().getDocumentGraph().addRelation((Relation)sDomRel);
            if (relation.getName() != null) {
                sDomRel.createAnnotation(null, ((RSTImporterProperties)this.getProperties()).getRelationName(), (Object)relation.getName());
            }
        }
    }
}

