/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.rstModules;

import java.util.Hashtable;
import java.util.List;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.peppermodules.rstModules.RSTImporterProperties;
import org.corpus_tools.peppermodules.rstModules.models.Group;
import org.corpus_tools.peppermodules.rstModules.models.RSTDocument;
import org.corpus_tools.peppermodules.rstModules.models.Relation;
import org.corpus_tools.peppermodules.rstModules.models.Segment;
import org.corpus_tools.peppermodules.rstModules.models.Signal;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDominanceRelation;
import org.corpus_tools.salt.common.SStructure;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.common.tokenizer.SimpleTokenizer;
import org.corpus_tools.salt.common.tokenizer.Tokenizer;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Node;

public class RST2SaltMapper
extends PepperMapperImpl
implements PepperMapper {
    private RSTDocument currentRSTDocument = null;
    private Hashtable<String, SStructure> rstId2SStructure = null;
    private Tokenizer tokenizer = null;
    public static final String NODE_KIND_SEGMENT = "segment";
    public static final String NODE_KIND_GROUP = "group";

    public RST2SaltMapper() {
        this.init();
    }

    private void init() {
        this.tokenizer = new Tokenizer();
        this.rstId2SStructure = new Hashtable();
    }

    public void setCurrentRSTDocument(RSTDocument currentRSTDocument) {
        this.currentRSTDocument = currentRSTDocument;
    }

    public RSTDocument getCurrentRSTDocument() {
        return this.currentRSTDocument;
    }

    public DOCUMENT_STATUS mapSDocument() {
        RSTDocument rstDocument = new RSTDocument(this.getResourceURI());
        this.mapSDocument(rstDocument);
        return DOCUMENT_STATUS.COMPLETED;
    }

    public void mapSDocument(RSTDocument rstDocument) {
        if (this.getDocument().getDocumentGraph() == null) {
            this.getDocument().setDocumentGraph(SaltFactory.createSDocumentGraph());
        }
        this.setCurrentRSTDocument(rstDocument);
        if (this.getCurrentRSTDocument().getSegments().size() > 0) {
            if (((RSTImporterProperties)this.getProperties()).isToTokenize().booleanValue()) {
                this.mapSegmentsWithTokenize(this.getCurrentRSTDocument().getSegments());
            } else {
                this.mapSegmentsWithoutTokenize(this.getCurrentRSTDocument().getSegments());
            }
        }
        for (Group group : this.getCurrentRSTDocument().getGroups()) {
            this.mapGroup2SStructure(group);
        }
        for (Relation relation : this.getCurrentRSTDocument().getRelations()) {
            this.mapRelation(relation);
        }
        this.mapSignals();
    }

    public Tokenizer getTokenizer() {
        return this.tokenizer;
    }

    public void mapSegmentsWithTokenize(List<Segment> segments) {
        STextualDS sText = null;
        int seenTokens = 0;
        Character[] seps = null;
        if (((RSTImporterProperties)this.getProperties()).getSimpleTokenizationSeparators() != null) {
            seps = ((RSTImporterProperties)this.getProperties()).getSimpleTokenizationSeparators().toArray(new Character[((RSTImporterProperties)this.getProperties()).getSimpleTokenizationSeparators().size()]);
        }
        if (segments != null && segments.size() > 0) {
            sText = SaltFactory.createSTextualDS();
            this.getDocument().getDocumentGraph().addNode((Node)sText);
            for (Segment segment : segments) {
                SimpleTokenizer tokenizer;
                List tokens = null;
                int start = 0;
                if (sText.getText() != null) {
                    start = sText.getText().length();
                    sText.setText(sText.getText() + ((RSTImporterProperties)this.getProperties()).getSegmentSeparator() + segment.getText());
                } else {
                    sText.setText(segment.getText());
                }
                int end = sText.getText().length();
                if (((RSTImporterProperties)this.getProperties()).getSimpleTokenizationSeparators() != null) {
                    tokenizer = new SimpleTokenizer();
                    seenTokens = this.getDocument().getDocumentGraph().getTokens().size() - 1;
                    tokenizer.setDocumentGraph(this.getDocument().getDocumentGraph());
                    tokenizer.tokenize(sText, Integer.valueOf(start), Integer.valueOf(end), seps);
                    tokens = this.getDocument().getDocumentGraph().getTokens().subList(seenTokens + 1, this.getDocument().getDocumentGraph().getTokens().size());
                } else {
                    tokenizer = this.getDocument().getDocumentGraph().createTokenizer();
                    tokens = tokenizer.tokenize(sText, null, Integer.valueOf(start), Integer.valueOf(end));
                }
                if (tokens == null || tokens.size() <= 0) continue;
                SStructure sStruct = SaltFactory.createSStructure();
                sStruct.setName(segment.getId());
                sStruct.createAnnotation(null, ((RSTImporterProperties)this.getProperties()).getNodeKindName(), (Object)NODE_KIND_SEGMENT);
                if (segment.getType() != null) {
                    sStruct.createAnnotation(null, ((RSTImporterProperties)this.getProperties()).getNodeTypeName(), (Object)segment.getType());
                }
                this.rstId2SStructure.put(segment.getId(), sStruct);
                this.getDocument().getDocumentGraph().addNode((Node)sStruct);
                for (SToken sToken : tokens) {
                    SDominanceRelation sDomRel = SaltFactory.createSDominanceRelation();
                    sDomRel.setSource((Node)sStruct);
                    sDomRel.setTarget((Node)sToken);
                    this.getDocument().getDocumentGraph().addRelation((org.corpus_tools.salt.graph.Relation)sDomRel);
                }
            }
        }
    }

    private void mapSegmentsWithoutTokenize(List<Segment> segments) {
        STextualDS sText = null;
        if (segments != null && segments.size() > 0) {
            sText = SaltFactory.createSTextualDS();
            this.getDocument().getDocumentGraph().addNode((Node)sText);
            StringBuffer strBuffer = new StringBuffer();
            int i = 0;
            for (Segment segment : segments) {
                ++i;
                SStructure sStruct = SaltFactory.createSStructure();
                sStruct.createAnnotation(null, ((RSTImporterProperties)this.getProperties()).getNodeKindName(), (Object)NODE_KIND_SEGMENT);
                if (segment.getType() != null) {
                    sStruct.createAnnotation(null, ((RSTImporterProperties)this.getProperties()).getNodeTypeName(), (Object)segment.getType());
                }
                sStruct.setName(segment.getId());
                this.rstId2SStructure.put(segment.getId(), sStruct);
                this.getDocument().getDocumentGraph().addNode((Node)sStruct);
                SToken sToken = SaltFactory.createSToken();
                this.getDocument().getDocumentGraph().addNode((Node)sToken);
                STextualRelation sTextRel = SaltFactory.createSTextualRelation();
                sTextRel.setTarget((Node)sText);
                sTextRel.setSource((Node)sToken);
                sTextRel.setStart((Number)strBuffer.length());
                sTextRel.setEnd((Number)(strBuffer.length() + segment.getText().length()));
                this.getDocument().getDocumentGraph().addRelation((org.corpus_tools.salt.graph.Relation)sTextRel);
                SDominanceRelation sDomRel = SaltFactory.createSDominanceRelation();
                sDomRel.setSource((Node)sStruct);
                sDomRel.setTarget((Node)sToken);
                this.getDocument().getDocumentGraph().addRelation((org.corpus_tools.salt.graph.Relation)sDomRel);
                if (i != 0) {
                    strBuffer.append(((RSTImporterProperties)this.getProperties()).getSegmentSeparator());
                }
                strBuffer.append(segment.getText());
            }
            sText.setText(strBuffer.toString());
        }
    }

    private SStructure mapGroup2SStructure(Group group) {
        SStructure sStructure = null;
        if (group != null) {
            sStructure = SaltFactory.createSStructure();
            sStructure.setName(group.getId());
            if (group.getType() != null) {
                sStructure.createAnnotation(null, ((RSTImporterProperties)this.getProperties()).getNodeTypeName(), (Object)group.getType());
            }
            this.rstId2SStructure.put(group.getId(), sStructure);
            SAnnotation sAnno = SaltFactory.createSAnnotation();
            sAnno.setName(((RSTImporterProperties)this.getProperties()).getNodeKindName());
            sAnno.setValue((Object)NODE_KIND_GROUP);
            sStructure.addAnnotation(sAnno);
            this.getDocument().getDocumentGraph().addNode((Node)sStructure);
        }
        return sStructure;
    }

    private void mapRelation(Relation relation) {
        if (relation != null) {
            if (relation.getParent() == null) {
                throw new PepperModuleException((PepperMapper)this, "Cannot map the rst-model of file'" + this.getResourceURI() + "', because the parent of a relation is empty.");
            }
            if (relation.getParent() == null) {
                throw new PepperModuleException((PepperMapper)this, "Cannot map the rst-model of file'" + this.getResourceURI() + "', because the source of a relation is empty.");
            }
            SStructure sSource = this.rstId2SStructure.get(relation.getParent().getId());
            SStructure sTarget = this.rstId2SStructure.get(relation.getChild().getId());
            if (sSource == null) {
                throw new PepperModuleException((PepperMapper)this, "Cannot map the rst-model of file'" + this.getResourceURI() + "', because the parent of a relation points to a non existing node with id '" + relation.getChild().getId() + "'.");
            }
            if (sTarget == null) {
                throw new PepperModuleException((PepperMapper)this, "Cannot map the rst-model of file'" + this.getResourceURI() + "', because the parent of a relation belongs to a non existing node with id '" + relation.getParent().getId() + "'.");
            }
            SDominanceRelation sDomRel = SaltFactory.createSDominanceRelation();
            if (relation.getType() != null) {
                sDomRel.setType(relation.getType());
            }
            sDomRel.setSource((Node)sSource);
            sDomRel.setTarget((Node)sTarget);
            this.getDocument().getDocumentGraph().addRelation((org.corpus_tools.salt.graph.Relation)sDomRel);
            if (relation.getName() != null) {
                sDomRel.createAnnotation(null, ((RSTImporterProperties)this.getProperties()).getRelationName(), (Object)relation.getName());
            }
        }
    }

    private void mapSignals() {
        List<Signal> signals = this.getCurrentRSTDocument().getSignals();
        if (signals != null && signals.size() > 0) {
            SLayer signalsLayer = SaltFactory.createSLayer();
            String layerName = ((RSTImporterProperties)this.getProperties()).getSignalsLayerName();
            signalsLayer.setName(layerName);
            for (Signal signal : this.getCurrentRSTDocument().getSignals()) {
                this.mapSignal(signal, signalsLayer);
            }
            this.getDocument().addLayer((Layer)signalsLayer);
        }
    }

    private void mapSignal(Signal signal, SLayer layer) {
        if (signal == null) {
            return;
        }
        if (signal.getSource() == null) {
            throw new PepperModuleException((PepperMapper)this, "Cannot map the rst-model of file'" + this.getResourceURI() + "', because the source of a signal is empty.");
        }
        SStructure sSource = this.rstId2SStructure.get(signal.getSource().getId());
        if (sSource == null) {
            throw new PepperModuleException((PepperMapper)this, "Cannot map the rst-model of file'" + this.getResourceURI() + "', because the parent of a signal points to a non existing node with id '" + signal.getSource().getId() + "'.");
        }
        SStructure signalNode = SaltFactory.createSStructure();
        SAnnotation type = SaltFactory.createSAnnotation();
        type.setName("signal_type");
        type.setValue((Object)signal.getType());
        SAnnotation subtype = SaltFactory.createSAnnotation();
        subtype.setName("signal_subtype");
        subtype.setValue((Object)signal.getSubtype());
        signalNode.addAnnotation(type);
        signalNode.addAnnotation(subtype);
        layer.addNode((Node)signalNode);
        this.getDocument().getDocumentGraph().addNode((Node)signalNode);
        SDominanceRelation signal2rstNode = SaltFactory.createSDominanceRelation();
        signal2rstNode.setSource((Node)signalNode);
        signal2rstNode.setTarget((Node)this.rstId2SStructure.get(signal.getSource()));
        layer.addRelation((org.corpus_tools.salt.graph.Relation)signal2rstNode);
        List<Integer> tokenIds = signal.getTokenIds();
        if (tokenIds != null) {
            List sTokens = this.getDocument().getDocumentGraph().getTokens();
            for (int tokenId : signal.getTokenIds()) {
                SDominanceRelation signal2token = SaltFactory.createSDominanceRelation();
                signal2token.setSource((Node)signalNode);
                signal2token.setTarget((Node)sTokens.get(tokenId - 1));
                layer.addRelation((org.corpus_tools.salt.graph.Relation)signal2token);
            }
        }
    }
}

