/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.rstModules.models;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.corpus_tools.peppermodules.rstModules.models.AbstractNode;
import org.corpus_tools.peppermodules.rstModules.models.Group;
import org.corpus_tools.peppermodules.rstModules.models.RSTException;
import org.corpus_tools.peppermodules.rstModules.models.Relation;
import org.corpus_tools.peppermodules.rstModules.models.Segment;
import org.corpus_tools.peppermodules.rstModules.models.Signal;
import org.corpus_tools.peppermodules.rstModules.reader.RSTReader;
import org.eclipse.emf.common.util.URI;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class RSTDocument {
    private List<Segment> segments;
    private List<Group> groups;
    private List<Relation> relations;
    private List<Signal> signals;

    public List<Segment> getSegments() {
        return this.segments;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public List<Relation> getRelations() {
        return this.relations;
    }

    public List<Signal> getSignals() {
        return this.signals;
    }

    public List<Relation> getIncomingRelations(String id) {
        ArrayList<Relation> retVal = null;
        if (this.getRelations() != null) {
            for (Relation relation : this.getRelations()) {
                if (!relation.getChild().getId().equals(id)) continue;
                if (retVal == null) {
                    retVal = new ArrayList<Relation>();
                }
                retVal.add(relation);
            }
        }
        return retVal;
    }

    public Relation getOutgoingRelation(String id) {
        Relation retVal = null;
        if (this.getRelations() != null) {
            for (Relation relation : this.getRelations()) {
                if (!relation.getParent().getId().equals(id)) continue;
                retVal = relation;
                break;
            }
        }
        return retVal;
    }

    public List<Relation> getOutgoingRelations(String id) {
        ArrayList<Relation> retVal = null;
        if (this.getRelations() != null) {
            for (Relation relation : this.getRelations()) {
                if (!relation.getParent().getId().equals(id)) continue;
                if (retVal == null) {
                    retVal = new ArrayList<Relation>();
                }
                retVal.add(relation);
            }
        }
        return retVal;
    }

    public Relation createRelation(AbstractNode parent, AbstractNode child, String name, String type) {
        Relation rel = new Relation();
        rel.setParent(parent);
        rel.setChild(child);
        rel.setName(name);
        rel.setType(type);
        this.getRelations().add(rel);
        return rel;
    }

    private void init() {
        this.segments = new ArrayList<Segment>();
        this.groups = new ArrayList<Group>();
        this.relations = new ArrayList<Relation>();
        this.signals = new ArrayList<Signal>();
    }

    public RSTDocument() {
        this.init();
    }

    public RSTDocument(URI uri) {
        this.init();
        this.loadFile(uri);
    }

    private void loadFile(URI uri) {
        XMLReader xmlReader;
        SAXParser parser;
        if (uri == null) {
            throw new RSTException("Cannot load any resource, because no uri is given.");
        }
        File rstFile = new File(uri.toFileString());
        if (!rstFile.exists()) {
            throw new RSTException("Cannot load resource, because the file does not exist: " + rstFile);
        }
        if (!rstFile.canRead()) {
            throw new RSTException("Cannot load resource, because the file can not be read: " + rstFile);
        }
        RSTReader rstReader = new RSTReader();
        rstReader.setRstFile(rstFile);
        rstReader.setRSTDocument(this);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            parser = factory.newSAXParser();
            xmlReader = parser.getXMLReader();
            xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", rstReader);
            xmlReader.setContentHandler(rstReader);
        }
        catch (ParserConfigurationException e) {
            throw new RSTException("Cannot load RST from resource '" + rstFile.getAbsolutePath() + "'.", e);
        }
        catch (Exception e) {
            throw new RSTException("Cannot load RST from resource '" + rstFile.getAbsolutePath() + "'.", e);
        }
        try {
            FileInputStream inputStream = new FileInputStream(rstFile);
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            InputSource is = new InputSource(reader);
            is.setEncoding("UTF-8");
            xmlReader.parse(is);
        }
        catch (FileNotFoundException e) {
            throw new RSTException("File not found: " + rstFile.getAbsolutePath() + ".", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RSTException("File not in supported encoding: " + rstFile.getAbsolutePath() + ".", e);
        }
        catch (IOException e) {
            throw new RSTException("Error reading " + rstFile.getAbsolutePath() + ".", e);
        }
        catch (SAXException e) {
            try {
                parser = factory.newSAXParser();
                xmlReader = parser.getXMLReader();
                xmlReader.parse(rstFile.getAbsolutePath());
                xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", rstReader);
                xmlReader.setContentHandler(rstReader);
            }
            catch (Exception e1) {
                throw new RSTException("Cannot load RST from resource '" + rstFile.getAbsolutePath() + "'.", e1);
            }
        }
    }
}

