/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement;

public class DistanceHelper {
    public static final double H_REACHED_BUT_NULL = 0.05;
    public static final double H_NOT_NULL = 0.1;
    public static final int MAX_CHAR_DISTANCE = 65536;

    public static int distanceToDigit(char c) {
        return DistanceHelper.distanceToRange(c, '0', '9');
    }

    public static int distanceToRange(char c, char minInclusive, char maxInclusive) {
        if (minInclusive >= maxInclusive) {
            throw new IllegalArgumentException("Invalid char range '" + minInclusive + "'-'" + maxInclusive + "'");
        }
        int diffAfter = minInclusive - c;
        int diffBefore = c - maxInclusive;
        int dist = Math.max(diffAfter, 0) + Math.max(diffBefore, 0);
        return dist;
    }

    public static int distanceToChar(char c, char target) {
        return Math.abs(c - target);
    }

    public static long getLeftAlignmentDistance(String a, String b) {
        long diff = Math.abs(a.length() - b.length());
        long dist = diff * 65536L;
        for (int i = 0; i < Math.min(a.length(), b.length()); ++i) {
            dist += (long)Math.abs(a.charAt(i) - b.charAt(i));
        }
        assert (dist >= 0L);
        return dist;
    }

    public static double getDistanceToEquality(long a, long b) {
        return DistanceHelper.getDistanceToEquality((double)a, (double)b);
    }

    public static double getDistanceToEquality(int a, int b) {
        return DistanceHelper.getDistanceToEquality((double)a, (double)b);
    }

    public static double getDistanceToEquality(double a, double b) {
        if (!Double.isFinite(a) || !Double.isFinite(b)) {
            return Double.MAX_VALUE;
        }
        double distance = a < b ? b - a : a - b;
        if (distance < 0.0 || !Double.isFinite(distance)) {
            return Double.MAX_VALUE;
        }
        return distance;
    }
}

