/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes;

import java.util.Objects;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.DistanceHelper;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.heuristic.Truthness;
import org.evomaster.client.java.instrumentation.heuristic.TruthnessUtils;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class ObjectsClassReplacement
implements MethodReplacementClass {
    @Override
    public Class<?> getTargetClass() {
        return Objects.class;
    }

    @Replacement(type=ReplacementType.BOOLEAN, replacingStatic=true)
    public static boolean equals(Object left, Object right, String idTemplate) {
        boolean result = Objects.equals(left, right);
        if (idTemplate == null) {
            return result;
        }
        Truthness t = result ? new Truthness(1.0, 0.0) : (left != null && right != null ? ObjectsClassReplacement.computeDistance(left, right, idTemplate) : new Truthness(0.0, 1.0));
        ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, t);
        return result;
    }

    private static Truthness computeDistance(Object left, Object right, String idTemplate) {
        Objects.requireNonNull(left);
        Objects.requireNonNull(right);
        if (left instanceof String && right instanceof String) {
            String caller = (String)left;
            long distance = DistanceHelper.getLeftAlignmentDistance(caller, right.toString());
            return new Truthness(1.0 / (1.0 + (double)distance), 1.0);
        }
        if (left instanceof Integer && right instanceof Integer) {
            int caller = (Integer)left;
            int input = (Integer)right;
            return TruthnessUtils.getEqualityTruthness(caller, input);
        }
        if (left instanceof Long && right instanceof Long) {
            long caller = (Long)left;
            long input = (Long)right;
            return TruthnessUtils.getEqualityTruthness(caller, input);
        }
        if (left instanceof Float && right instanceof Float) {
            float caller = ((Float)left).floatValue();
            float input = ((Float)right).floatValue();
            return TruthnessUtils.getEqualityTruthness(caller, input);
        }
        if (left instanceof Double && right instanceof Double) {
            double caller = (Double)left;
            double input = (Double)right;
            return TruthnessUtils.getEqualityTruthness(caller, input);
        }
        if (left instanceof Character && right instanceof Character) {
            long distance = DistanceHelper.getLeftAlignmentDistance(left.toString(), right.toString());
            return new Truthness(1.0 / (1.0 + (double)distance), 1.0);
        }
        return new Truthness(0.0, 1.0);
    }
}

