/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.internal.db.constraint;

import java.sql.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.evomaster.client.java.controller.api.dto.database.schema.DbSchemaDto;
import org.evomaster.client.java.controller.api.dto.database.schema.TableDto;
import org.evomaster.client.java.controller.internal.db.constraint.DbTableCheckExpression;
import org.evomaster.client.java.controller.internal.db.constraint.DbTableConstraint;
import org.evomaster.client.java.controller.internal.db.constraint.DbTableUniqueConstraint;
import org.evomaster.client.java.controller.internal.db.constraint.TableConstraintExtractor;
import org.evomaster.client.java.utils.SimpleLogger;

public class PostgresConstraintExtractor
extends TableConstraintExtractor {
    private static final String CONSTRAINT_TYPE_CHECK = "c";
    private static final String CONSTRAINT_TYPE_FOREIGN_KEY = "f";
    private static final String CONSTRAINT_TYPE_PRIMARY_KEY = "p";
    private static final String CONSTRAINT_TYPE_UNIQUE = "u";
    private static final String CONSTRAINT_TYPE_TRIGGER = "t";
    private static final String CONSTRAINT_TYPE_EXCLUSION = "x";
    private static final String CONTYPE = "contype";
    private static final String CONSRC = "consrc";
    public static final String CONKEY = "conkey";

    private static void cannotHandle(String constraintType) {
        SimpleLogger.uniqueWarn("WARNING, EvoMaster cannot extract Postgres constraints with type '" + constraintType);
    }

    private static DbTableUniqueConstraint getDbTableUniqueConstraint(Connection connectionToPostgres, String tableSchema, String tableName, Integer[] columnIds) throws SQLException {
        ArrayList<String> uniqueColumnNames = new ArrayList<String>();
        Integer[] integerArray = columnIds;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int columnId = integerArray[i];
            String qry = String.format("SELECT att.*  FROM pg_catalog.pg_attribute att  INNER JOIN pg_catalog.pg_class rel\n     ON rel.oid = att.attrelid\n  INNER JOIN pg_catalog.pg_namespace nsp\n     ON nsp.oid = rel.relnamespace\n  WHERE nsp.nspname = '%s'\n   AND rel.relname = '%s' \n   AND att.attnum =  %s;", tableSchema, tableName, columnId);
            try (Statement stmt = connectionToPostgres.createStatement();
                 ResultSet rs = stmt.executeQuery(qry);){
                boolean hasRows = rs.next();
                if (!hasRows) {
                    throw new IllegalStateException("Unexpected missing pg_catalog.pg_attribute data");
                }
                String uniqueColumnName = rs.getString("attname");
                uniqueColumnNames.add(uniqueColumnName);
                continue;
            }
        }
        return new DbTableUniqueConstraint(tableName, uniqueColumnNames);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<DbTableConstraint> extract(Connection connectionToPostgres, DbSchemaDto schemaDto) throws SQLException {
        String tableSchema = schemaDto.name;
        ArrayList<DbTableConstraint> constraints = new ArrayList<DbTableConstraint>();
        Iterator<TableDto> iterator = schemaDto.tables.iterator();
        block25: while (iterator.hasNext()) {
            TableDto tableDto = iterator.next();
            Statement statement = connectionToPostgres.createStatement();
            try {
                String tableName = tableDto.name;
                String query = String.format("SELECT con.*\n       FROM pg_catalog.pg_constraint con\n            INNER JOIN pg_catalog.pg_class rel\n                       ON rel.oid = con.conrelid\n            INNER JOIN pg_catalog.pg_namespace nsp\n                       ON nsp.oid = connamespace\n       WHERE nsp.nspname = '%s'\n             AND rel.relname = '%s';", tableSchema, tableName);
                ResultSet columns = statement.executeQuery(query);
                try {
                    block26: while (true) {
                        String constraintType;
                        if (!columns.next()) continue block25;
                        String checkConstraint = columns.getString(CONSRC);
                        Array array = columns.getArray(CONKEY);
                        switch (constraintType = columns.getString(CONTYPE)) {
                            case "c": {
                                DbTableConstraint constraint = new DbTableCheckExpression(tableName, checkConstraint);
                                constraints.add(constraint);
                                continue block26;
                            }
                            case "u": {
                                Integer[] uniqueColumnIds = (Integer[])array.getArray();
                                DbTableConstraint constraint = PostgresConstraintExtractor.getDbTableUniqueConstraint(connectionToPostgres, tableSchema, tableName, uniqueColumnIds);
                                constraints.add(constraint);
                                continue block26;
                            }
                            case "f": 
                            case "p": {
                                continue block26;
                            }
                            case "t": {
                                PostgresConstraintExtractor.cannotHandle("TRIGGER CONSTRAINT");
                                continue block26;
                            }
                            case "x": {
                                PostgresConstraintExtractor.cannotHandle("EXCLUSION CONSTRAINT");
                                continue block26;
                            }
                        }
                        PostgresConstraintExtractor.cannotHandle("Unknown constraint type " + constraintType);
                    }
                }
                finally {
                    if (columns == null) continue;
                    columns.close();
                    continue;
                }
            }
            finally {
                if (statement == null) continue;
                statement.close();
                continue;
            }
            break;
        }
        return constraints;
    }
}

