/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDateTime;
import java.util.Date;
import java.util.Objects;

public class DistanceHelper {
    public static final double H_REACHED_BUT_NULL = 0.05;
    public static final double H_NOT_NULL = 0.1;
    public static final double H_REACHED_BUT_EMPTY = 0.05;
    public static final double H_NOT_EMPTY = 0.1;
    public static final int MAX_CHAR_DISTANCE = 65536;

    public static int distanceToDigit(char c) {
        return DistanceHelper.distanceToRange(c, '0', '9');
    }

    public static int distanceToRange(char c, char minInclusive, char maxInclusive) {
        if (minInclusive >= maxInclusive) {
            throw new IllegalArgumentException("Invalid char range '" + minInclusive + "'-'" + maxInclusive + "'");
        }
        int diffAfter = minInclusive - c;
        int diffBefore = c - maxInclusive;
        int dist = Math.max(diffAfter, 0) + Math.max(diffBefore, 0);
        return dist;
    }

    public static int distanceToChar(char c, char target) {
        return Math.abs(c - target);
    }

    public static long getLeftAlignmentDistance(String a, String b) {
        long diff = Math.abs(a.length() - b.length());
        long dist = diff * 65536L;
        for (int i = 0; i < Math.min(a.length(), b.length()); ++i) {
            dist += (long)Math.abs(a.charAt(i) - b.charAt(i));
        }
        assert (dist >= 0L);
        return dist;
    }

    public static double getDistanceToEquality(long a, long b) {
        return DistanceHelper.getDistanceToEquality((double)a, (double)b);
    }

    public static double getDistanceToEquality(int a, int b) {
        return DistanceHelper.getDistanceToEquality((double)a, (double)b);
    }

    public static double getDistanceToEquality(char a, char b) {
        return DistanceHelper.getDistanceToEquality((double)a, (double)b);
    }

    public static double getDistanceToEquality(double a, double b) {
        if (!Double.isFinite(a) || !Double.isFinite(b)) {
            return Double.MAX_VALUE;
        }
        double distance = a < b ? b - a : a - b;
        if (distance < 0.0 || !Double.isFinite(distance)) {
            return Double.MAX_VALUE;
        }
        return distance;
    }

    public static double getDistanceToEquality(Date a, Date b) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        return DistanceHelper.getDistanceToEquality(a.getTime(), b.getTime());
    }

    public static double getDistanceToEquality(LocalDate a, LocalDate b) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        return DistanceHelper.getDistanceToEquality(a.toEpochDay(), b.toEpochDay());
    }

    public static double getDistanceToEquality(ChronoLocalDateTime<?> a, ChronoLocalDateTime<?> b) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        return DistanceHelper.getDistanceToEquality(DistanceHelper.getEpochMilli(a), DistanceHelper.getEpochMilli(b));
    }

    private static long getEpochMilli(ChronoLocalDateTime<?> chronoLocalDateTime) {
        return chronoLocalDateTime.atZone(ZoneOffset.UTC).toInstant().toEpochMilli();
    }

    public static double getDistanceToEquality(LocalTime a, LocalTime b) {
        return DistanceHelper.getDistanceToEquality(a.toSecondOfDay(), b.toSecondOfDay());
    }

    public static double getDistance(Object left, Object right) {
        double distance;
        Objects.requireNonNull(left);
        Objects.requireNonNull(right);
        if (left instanceof String && right instanceof String) {
            String a = (String)left;
            String b = right.toString();
            distance = DistanceHelper.getLeftAlignmentDistance(a, b);
        } else if (left instanceof Byte && right instanceof Byte) {
            Byte a = (Byte)left;
            Byte b = (Byte)right;
            distance = DistanceHelper.getDistanceToEquality(a.longValue(), b.longValue());
        } else if (left instanceof Short && right instanceof Short) {
            Short a = (Short)left;
            Short b = (Short)right;
            distance = DistanceHelper.getDistanceToEquality(a.longValue(), b.longValue());
        } else if (left instanceof Integer && right instanceof Integer) {
            int a = (Integer)left;
            int b = (Integer)right;
            distance = DistanceHelper.getDistanceToEquality(a, b);
        } else if (left instanceof Long && right instanceof Long) {
            long a = (Long)left;
            long b = (Long)right;
            distance = DistanceHelper.getDistanceToEquality(a, b);
        } else if (left instanceof Float && right instanceof Float) {
            float a = ((Float)left).floatValue();
            float b = ((Float)right).floatValue();
            distance = DistanceHelper.getDistanceToEquality(a, b);
        } else if (left instanceof Double && right instanceof Double) {
            double a = (Double)left;
            double b = (Double)right;
            distance = DistanceHelper.getDistanceToEquality(a, b);
        } else if (left instanceof Character && right instanceof Character) {
            Character a = (Character)left;
            Character b = (Character)right;
            distance = DistanceHelper.getDistanceToEquality(a.charValue(), b.charValue());
        } else if (left instanceof Date && right instanceof Date) {
            Date a = (Date)left;
            Date b = (Date)right;
            distance = DistanceHelper.getDistanceToEquality(a, b);
        } else if (left instanceof LocalDate && right instanceof LocalDate) {
            LocalDate a = (LocalDate)left;
            LocalDate b = (LocalDate)right;
            distance = DistanceHelper.getDistanceToEquality(a, b);
        } else if (left instanceof LocalTime && right instanceof LocalTime) {
            LocalTime a = (LocalTime)left;
            LocalTime b = (LocalTime)right;
            distance = DistanceHelper.getDistanceToEquality(a, b);
        } else if (left instanceof LocalDateTime && right instanceof LocalDateTime) {
            LocalDateTime a = (LocalDateTime)left;
            LocalDateTime b = (LocalDateTime)right;
            distance = DistanceHelper.getDistanceToEquality(a, b);
        } else {
            distance = Double.MAX_VALUE;
        }
        return distance;
    }
}

