/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.external;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collection;
import java.util.List;
import org.evomaster.client.java.instrumentation.Action;
import org.evomaster.client.java.instrumentation.AdditionalInfo;
import org.evomaster.client.java.instrumentation.TargetInfo;
import org.evomaster.client.java.instrumentation.external.Command;
import org.evomaster.client.java.instrumentation.staticstate.UnitsInfoRecorder;
import org.evomaster.client.java.utils.SimpleLogger;

public class ServerController {
    private ServerSocket server;
    private Socket socket;
    protected ObjectOutputStream out;
    protected ObjectInputStream in;

    public synchronized int startServer() {
        this.closeServer();
        try {
            this.server = new ServerSocket(0);
            this.server.setSoTimeout(10000);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return this.server.getLocalPort();
    }

    public synchronized void closeServer() {
        if (this.server != null) {
            try {
                this.server.close();
                this.server = null;
                this.socket = null;
                this.in = null;
                this.out = null;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public synchronized boolean waitForIncomingConnection() {
        try {
            this.socket = this.server.accept();
            this.socket.setSoTimeout(20000);
            this.out = new ObjectOutputStream(this.socket.getOutputStream());
            this.in = new ObjectInputStream(this.socket.getInputStream());
        }
        catch (InterruptedIOException e) {
            return false;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return this.isConnectionOn();
    }

    public synchronized boolean isConnectionOn() {
        return this.socket != null && this.socket.isConnected() && !this.socket.isClosed();
    }

    public synchronized boolean sendCommand(Command command) {
        return this.sendObject(command);
    }

    public synchronized boolean sendObject(Object obj) {
        if (!this.isConnectionOn()) {
            SimpleLogger.error("TCP connection is not on");
            return false;
        }
        try {
            this.out.writeObject(obj);
            this.out.reset();
        }
        catch (IOException e) {
            SimpleLogger.error("IO exception while sending object", e);
            return false;
        }
        return true;
    }

    public synchronized Object waitAndGetResponse() {
        if (!this.isConnectionOn()) {
            SimpleLogger.error("TCP connection is not on");
            return null;
        }
        try {
            Object obj = this.in.readObject();
            return obj;
        }
        catch (IOException e) {
            SimpleLogger.error("IO exception while waiting for response", e);
            return null;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public synchronized boolean sendAndExpectACK(Command command) {
        boolean sent = this.sendCommand(command);
        if (!sent) {
            SimpleLogger.error("Failed to send message");
            return false;
        }
        return this.waitForAck();
    }

    public synchronized boolean sendWithDataAndExpectACK(Command command, Object data) {
        boolean sent = this.sendCommand(command);
        if (!sent) {
            SimpleLogger.error("Failed to send message");
            return false;
        }
        sent = this.sendObject(data);
        if (!sent) {
            SimpleLogger.error("Failed to send message");
            return false;
        }
        return this.waitForAck();
    }

    private boolean waitForAck() {
        Object response = this.waitAndGetResponse();
        if (response == null) {
            SimpleLogger.error("Failed to read ACK response");
            return false;
        }
        if (!Command.ACK.equals(response)) {
            throw new IllegalStateException(this.errorMsgExpectingResponse(response, "an ACK"));
        }
        return true;
    }

    private String errorMsgExpectingResponse(Object response, String expectation) {
        String repMsg = response == null ? "NULL" : "an instance of type " + response.getClass() + " with value: " + response.toString();
        return "Invalid response. Expecting " + expectation + ", but rather received " + repMsg;
    }

    public boolean resetForNewSearch() {
        return this.sendAndExpectACK(Command.NEW_SEARCH);
    }

    public boolean resetForNewTest() {
        return this.sendAndExpectACK(Command.NEW_TEST);
    }

    public boolean setAction(Action action) {
        return this.sendWithDataAndExpectACK(Command.ACTION_INDEX, action);
    }

    public synchronized List<TargetInfo> getTargetsInfo(Collection<Integer> ids) {
        boolean sent = this.sendCommand(Command.TARGETS_INFO);
        if (!sent) {
            SimpleLogger.error("Failed to send message");
            return null;
        }
        if (!this.sendObject(ids)) {
            SimpleLogger.error("Failed to send ids");
            return null;
        }
        Object response = this.waitAndGetResponse();
        if (response == null) {
            SimpleLogger.error("Failed to read response about covered targets");
            return null;
        }
        if (!(response instanceof List)) {
            throw new IllegalStateException(this.errorMsgExpectingResponse(response, "a List"));
        }
        return (List)response;
    }

    public synchronized List<AdditionalInfo> getAdditionalInfoList() {
        boolean sent = this.sendCommand(Command.ADDITIONAL_INFO);
        if (!sent) {
            SimpleLogger.error("Failed to send message");
            return null;
        }
        Object response = this.waitAndGetResponse();
        if (response == null) {
            SimpleLogger.error("Failed to read response about additional info");
            return null;
        }
        if (!(response instanceof List)) {
            throw new IllegalStateException(this.errorMsgExpectingResponse(response, "a List"));
        }
        return (List)response;
    }

    public synchronized UnitsInfoRecorder getUnitsInfoRecorder() {
        boolean sent = this.sendCommand(Command.UNITS_INFO);
        if (!sent) {
            SimpleLogger.error("Failed to send message");
            return null;
        }
        Object response = this.waitAndGetResponse();
        if (response == null) {
            SimpleLogger.error("Failed to read response about units info");
            return null;
        }
        if (!(response instanceof UnitsInfoRecorder)) {
            throw new IllegalStateException(this.errorMsgExpectingResponse(response, "a UnitsInfoRecorder"));
        }
        return (UnitsInfoRecorder)response;
    }
}

