/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;

public abstract class ThirdPartyMethodReplacementClass
implements MethodReplacementClass {
    private Class<?> targetClass;
    private boolean triedToLoad = false;
    private final Map<String, Method> methods = new HashMap<String, Method>();

    protected ThirdPartyMethodReplacementClass() {
    }

    private void initMethods() {
        Class<?> subclass = this.getClass();
        for (Method m : subclass.getDeclaredMethods()) {
            Method targetMethod;
            Replacement r = m.getAnnotation(Replacement.class);
            if (r == null || r.id().isEmpty()) continue;
            Class<?>[] inputs = m.getParameterTypes();
            int start = 0;
            if (!r.replacingStatic()) {
                start = 1;
            }
            int end = inputs.length - 1;
            if (r.type() == ReplacementType.TRACKER) {
                end = inputs.length;
            }
            Class<?>[] reducedInputs = Arrays.copyOfRange(inputs, start, end);
            try {
                targetMethod = this.getTargetClass().getMethod(m.getName(), reducedInputs);
            }
            catch (NoSuchMethodException e) {
                try {
                    targetMethod = this.targetClass.getDeclaredMethod(m.getName(), reducedInputs);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new RuntimeException("BUG in EvoMaster: " + e);
                }
            }
            String id = r.id();
            if (this.methods.containsKey(id)) {
                throw new IllegalStateException("Non-unique id: " + id);
            }
            this.methods.put(id, targetMethod);
        }
    }

    protected abstract String getNameOfThirdPartyTargetClass();

    public static Method getOriginal(ThirdPartyMethodReplacementClass singleton, String id, Object obj) {
        Method original;
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("Invalid empty id");
        }
        Objects.requireNonNull(obj);
        if (singleton.getTargetClass() == null) {
            singleton.retryLoadingClass(obj.getClass().getClassLoader());
        }
        if (singleton.methods.isEmpty()) {
            singleton.initMethods();
        }
        if ((original = singleton.methods.get(id)) == null) {
            throw new IllegalArgumentException("No method exists with id: " + id);
        }
        return original;
    }

    private void retryLoadingClass(ClassLoader classLoader) {
        try {
            this.targetClass = classLoader.loadClass(this.getTargetClassName());
            this.triedToLoad = true;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("ISSUE IN EVOMASTER: classloader problems when dealing with: " + this.getTargetClassName());
        }
    }

    @Override
    public Class<?> getTargetClass() {
        if (this.targetClass != null) {
            return this.targetClass;
        }
        if (!this.triedToLoad) {
            this.triedToLoad = true;
            try {
                this.targetClass = Class.forName(this.getTargetClassName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.targetClass;
    }

    @Override
    public final String getTargetClassName() {
        return this.getNameOfThirdPartyTargetClass();
    }
}

