/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.ServletInputStream;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.ThirdPartyMethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.UsageFilter;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class HttpServletRequestClassReplacement
extends ThirdPartyMethodReplacementClass {
    private static final HttpServletRequestClassReplacement singleton = new HttpServletRequestClassReplacement();

    @Override
    protected String getNameOfThirdPartyTargetClass() {
        return "javax.servlet.http.HttpServletRequest";
    }

    @Replacement(replacingStatic=false, type=ReplacementType.TRACKER, id="getInputStream", usageFilter=UsageFilter.ONLY_SUT)
    public static ServletInputStream getInputStream(Object caller) throws IOException {
        if (caller == null) {
            throw new NullPointerException();
        }
        ExecutionTracer.markRawAccessOfHttpBodyPayload();
        Method original = HttpServletRequestClassReplacement.getOriginal(singleton, "getInputStream", caller);
        try {
            return (ServletInputStream)original.invoke(caller, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw (RuntimeException)e.getCause();
        }
    }
}

