/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.shared;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TaintInputName {
    private static final String PREFIX = "evomaster_";
    private static final String POSTFIX = "_input";
    private static final Pattern pattern = Pattern.compile("\\Qevomaster_\\E\\d+\\Q_input\\E");

    public static boolean isTaintInput(String value) {
        if (value == null) {
            return false;
        }
        Matcher matcher = pattern.matcher(value);
        return matcher.matches();
    }

    public static boolean includesTaintInput(String value) {
        if (value == null) {
            return false;
        }
        Matcher matcher = pattern.matcher(value);
        return matcher.find();
    }

    public static String getTaintName(int id) {
        if (id < 0) {
            throw new IllegalArgumentException("Negative id");
        }
        return PREFIX + id + POSTFIX;
    }
}

