/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.BooleanClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.ByteClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.CharacterClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.CollectionClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.DateClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.DateFormatClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.DoubleClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.FloatClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.IntegerClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.LocalDateClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.LocalDateTimeClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.LocalTimeClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.LongClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.MapClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.MatcherClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.MethodClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.ObjectsClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.PatternClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.PreparedStatementClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.ShortClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.StatementClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.StringClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses.AbstractEndpointClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses.GsonClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses.Http11ProcessorReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses.HttpServletRequestClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses.ServletRequestClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses.WebRequestClassReplacement;
import org.evomaster.client.java.instrumentation.shared.ClassName;

public class ReplacementList {
    public static List<MethodReplacementClass> getList() {
        return Arrays.asList(new AbstractEndpointClassReplacement(), new BooleanClassReplacement(), new ByteClassReplacement(), new CharacterClassReplacement(), new CollectionClassReplacement(), new DateClassReplacement(), new DateFormatClassReplacement(), new DoubleClassReplacement(), new FloatClassReplacement(), new GsonClassReplacement(), new Http11ProcessorReplacementClass(), new HttpServletRequestClassReplacement(), new IntegerClassReplacement(), new LocalDateClassReplacement(), new LocalDateTimeClassReplacement(), new LocalTimeClassReplacement(), new LongClassReplacement(), new MapClassReplacement(), new MatcherClassReplacement(), new MethodClassReplacement(), new ObjectsClassReplacement(), new PatternClassReplacement(), new PreparedStatementClassReplacement(), new StatementClassReplacement(), new StringClassReplacement(), new ShortClassReplacement(), new ServletRequestClassReplacement(), new WebRequestClassReplacement());
    }

    public static List<MethodReplacementClass> getReplacements(String target) {
        Objects.requireNonNull(target);
        String targetClassName = ClassName.get(target).getFullNameWithDots();
        return ReplacementList.getList().stream().filter(t -> {
            boolean jdk;
            HashSet<String> prefixes = new HashSet<String>();
            prefixes.add("java.lang.");
            prefixes.add("java.util.");
            prefixes.add("java.time.");
            prefixes.add("java.sql.Statement");
            prefixes.add("java.sql.CallableStatement");
            prefixes.add("java.sql.PreparedStatement");
            boolean bl = jdk = prefixes.stream().anyMatch(k -> targetClassName.startsWith((String)k)) && prefixes.stream().anyMatch(k -> t.getTargetClassName().startsWith((String)k));
            if (jdk) {
                Class<?> klass;
                try {
                    klass = Class.forName(targetClassName);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return t.getTargetClass().isAssignableFrom(klass);
            }
            return t.getTargetClassName().equals(targetClassName);
        }).collect(Collectors.toList());
    }
}

