/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.CollectionsDistanceUtils;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.heuristic.Truthness;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.shared.StringSpecialization;
import org.evomaster.client.java.instrumentation.shared.StringSpecializationInfo;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class MapClassReplacement
implements MethodReplacementClass {
    @Override
    public Class<?> getTargetClass() {
        return Map.class;
    }

    @Replacement(type=ReplacementType.BOOLEAN)
    public static boolean containsKey(Map c, Object o, String idTemplate) {
        Truthness t;
        Objects.requireNonNull(c);
        if (idTemplate == null || c instanceof IdentityHashMap) {
            return c.containsKey(o);
        }
        String inputString = null;
        if (o instanceof String) {
            inputString = (String)o;
        }
        Set keyCollection = c.keySet();
        if (ExecutionTracer.isTaintInput(inputString)) {
            int counter = 0;
            for (Object value : keyCollection) {
                if (!(value instanceof String)) continue;
                ExecutionTracer.addStringSpecialization(inputString, new StringSpecializationInfo(StringSpecialization.CONSTANT, (String)value));
                if (++counter < 10) continue;
                break;
            }
        }
        boolean result = keyCollection.contains(o);
        if (idTemplate == null) {
            return result;
        }
        if (result) {
            t = new Truthness(1.0, 0.1);
        } else {
            double h = CollectionsDistanceUtils.getHeuristicToContains(keyCollection, o, 50);
            t = new Truthness(h, 1.0);
        }
        ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, t);
        return result;
    }
}

