/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes;

import java.util.Objects;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.DistanceHelper;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.NumberParsingUtils;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.heuristic.Truthness;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.shared.StringSpecialization;
import org.evomaster.client.java.instrumentation.shared.StringSpecializationInfo;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class ShortClassReplacement
implements MethodReplacementClass {
    @Override
    public Class<?> getTargetClass() {
        return Short.class;
    }

    @Replacement(type=ReplacementType.EXCEPTION, replacingStatic=true)
    public static short parseShort(String input, String idTemplate) {
        if (ExecutionTracer.isTaintInput(input)) {
            ExecutionTracer.addStringSpecialization(input, new StringSpecializationInfo(StringSpecialization.INTEGER, null));
        }
        if (idTemplate == null) {
            return Short.parseShort(input);
        }
        try {
            short res = Short.parseShort(input);
            ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.EXCEPTION, new Truthness(1.0, 0.1));
            return res;
        }
        catch (RuntimeException e) {
            double h = NumberParsingUtils.parseShortHeuristic(input);
            ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.EXCEPTION, new Truthness(h, 1.0));
            throw e;
        }
    }

    @Replacement(type=ReplacementType.BOOLEAN)
    public static boolean equals(Short caller, Object anObject, String idTemplate) {
        Truthness t;
        Objects.requireNonNull(caller);
        if (idTemplate == null) {
            return caller.equals(anObject);
        }
        if (anObject == null || !(anObject instanceof Short)) {
            t = new Truthness(0.05, 1.0);
        } else {
            Short anotherShort = (Short)anObject;
            if (caller.equals(anotherShort)) {
                t = new Truthness(1.0, 0.1);
            } else {
                double base = 0.1;
                double distance = DistanceHelper.getDistanceToEquality(caller.shortValue(), anotherShort.shortValue());
                double h = DistanceHelper.heuristicFromScaledDistanceWithBase(base, distance);
                t = new Truthness(h, 1.0);
            }
        }
        ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, t);
        return caller.equals(anObject);
    }

    @Replacement(type=ReplacementType.EXCEPTION, replacingStatic=true)
    public static short valueOf(String input, String idTemplate) {
        return ShortClassReplacement.parseShort(input, idTemplate);
    }
}

