/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.evomaster.client.java.instrumentation.SqlInfo;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;
import shaded.net.sf.jsqlparser.JSQLParserException;
import shaded.net.sf.jsqlparser.parser.CCJSqlParserUtil;

public class StatementClassReplacement
implements MethodReplacementClass {
    @Override
    public Class<?> getTargetClass() {
        return Statement.class;
    }

    private static void handleSql(String sql, boolean exception, long executionTime) {
        if (sql != null) {
            SqlInfo info = new SqlInfo(StatementClassReplacement.formatSql(sql), false, exception, executionTime);
            ExecutionTracer.addSqlInfo(info);
        }
    }

    @Replacement(type=ReplacementType.TRACKER, isPure=false)
    public static ResultSet executeQuery(Statement caller, String sql) throws SQLException {
        return StatementClassReplacement.executeSql(() -> caller.executeQuery(sql), sql);
    }

    @Replacement(type=ReplacementType.TRACKER, isPure=false)
    public static int executeUpdate(Statement caller, String sql) throws SQLException {
        return StatementClassReplacement.executeSql(() -> caller.executeUpdate(sql), sql);
    }

    @Replacement(type=ReplacementType.TRACKER, isPure=false)
    public static boolean execute(Statement caller, String sql) throws SQLException {
        return StatementClassReplacement.executeSql(() -> caller.execute(sql), sql);
    }

    @Replacement(type=ReplacementType.TRACKER, isPure=false)
    public static int executeUpdate(Statement caller, String sql, int autoGeneratedKeys) throws SQLException {
        return StatementClassReplacement.executeSql(() -> caller.executeUpdate(sql, autoGeneratedKeys), sql);
    }

    @Replacement(type=ReplacementType.TRACKER, isPure=false)
    public static int executeUpdate(Statement caller, String sql, int[] columnIndexes) throws SQLException {
        return StatementClassReplacement.executeSql(() -> caller.executeUpdate(sql, columnIndexes), sql);
    }

    @Replacement(type=ReplacementType.TRACKER, isPure=false)
    public static int executeUpdate(Statement caller, String sql, String[] columnNames) throws SQLException {
        return StatementClassReplacement.executeSql(() -> caller.executeUpdate(sql, columnNames), sql);
    }

    @Replacement(type=ReplacementType.TRACKER, isPure=false)
    public static boolean execute(Statement caller, String sql, int autoGeneratedKeys) throws SQLException {
        return StatementClassReplacement.executeSql(() -> caller.execute(sql, autoGeneratedKeys), sql);
    }

    @Replacement(type=ReplacementType.TRACKER, isPure=false)
    public static boolean execute(Statement caller, String sql, int[] columnIndexes) throws SQLException {
        return StatementClassReplacement.executeSql(() -> caller.execute(sql, columnIndexes), sql);
    }

    @Replacement(type=ReplacementType.TRACKER, isPure=false)
    public static boolean execute(Statement caller, String sql, String[] columnNames) throws SQLException {
        return StatementClassReplacement.executeSql(() -> caller.execute(sql, columnNames), sql);
    }

    @Replacement(type=ReplacementType.TRACKER, isPure=false)
    public static long executeLargeUpdate(Statement caller, String sql) throws SQLException {
        return StatementClassReplacement.executeSql(() -> caller.executeLargeUpdate(sql), sql);
    }

    @Replacement(type=ReplacementType.TRACKER, isPure=false)
    public static long executeLargeUpdate(Statement caller, String sql, int autoGeneratedKeys) throws SQLException {
        return StatementClassReplacement.executeSql(() -> caller.executeLargeUpdate(sql, autoGeneratedKeys), sql);
    }

    @Replacement(type=ReplacementType.TRACKER, isPure=false)
    public static long executeLargeUpdate(Statement caller, String sql, int[] columnIndexes) throws SQLException {
        return StatementClassReplacement.executeSql(() -> caller.executeLargeUpdate(sql, columnIndexes), sql);
    }

    @Replacement(type=ReplacementType.TRACKER, isPure=false)
    public static long executeLargeUpdate(Statement caller, String sql, String[] columnNames) throws SQLException {
        return StatementClassReplacement.executeSql(() -> caller.executeLargeUpdate(sql, columnNames), sql);
    }

    public static <T> T executeSql(SqlExecutionSupplier<T, SQLException> executeStatement, String sql) throws SQLException {
        long start = System.currentTimeMillis();
        try {
            T result = executeStatement.get();
            long end = System.currentTimeMillis();
            StatementClassReplacement.handleSql(sql, false, end - start);
            return result;
        }
        catch (SQLException e) {
            StatementClassReplacement.handleSql(sql, true, SqlInfo.FAILURE_EXTIME);
            throw e;
        }
    }

    private static String formatSql(String sql) {
        try {
            return CCJSqlParserUtil.parse(sql).toString();
        }
        catch (JSQLParserException e) {
            return sql;
        }
    }

    @FunctionalInterface
    public static interface SqlExecutionSupplier<T, E extends Exception> {
        public T get() throws E;
    }
}

