/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.db.h2;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import shaded.com.fasterxml.jackson.core.Version;
import shaded.com.fasterxml.jackson.core.util.VersionUtil;

public abstract class H2VersionUtils {
    private static final int COLUMN_INDEX_H2_VERSION = 1;
    public static final String H2_VERSION_2_0_0 = "2.0.0";

    public static synchronized boolean isVersionGreaterOrEqual(String versionString, String otherVersionString) {
        Version otherVersion;
        Version version = VersionUtil.parseVersion(versionString, null, null);
        return version.compareTo(otherVersion = VersionUtil.parseVersion(otherVersionString, null, null)) >= 0;
    }

    public static synchronized String getH2Version(Connection connectionToH2) throws SQLException {
        try (Statement statement = connectionToH2.createStatement();){
            ResultSet columns;
            try {
                String selectH2versionQuery = "SELECT H2VERSION();";
                columns = statement.executeQuery("SELECT H2VERSION();");
            }
            catch (SQLException ex) {
                if (ex.getMessage() != null && ex.getMessage().contains("Function \"H2VERSION\" not found")) {
                    String query = "SELECT value FROM information_schema.settings WHERE name = 'info.VERSION';";
                    columns = statement.executeQuery("SELECT value FROM information_schema.settings WHERE name = 'info.VERSION';");
                }
                throw ex;
            }
            boolean hasNext = columns.next();
            if (!hasNext) {
                throw new IllegalArgumentException("No results for query: SELECT H2VERSION();");
            }
            String string = columns.getString(1);
            return string;
        }
    }
}

