/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.internal.db.constraint;

import org.evomaster.client.java.controller.api.dto.database.schema.DatabaseType;
import org.evomaster.client.java.controller.internal.db.constraint.H2ConstraintExtractor;
import org.evomaster.client.java.controller.internal.db.constraint.MySQLConstraintExtractor;
import org.evomaster.client.java.controller.internal.db.constraint.PostgresConstraintExtractor;
import org.evomaster.client.java.controller.internal.db.constraint.TableConstraintExtractor;

public class TableConstraintExtractorFactory {
    private TableConstraintExtractorFactory() {
    }

    public static TableConstraintExtractor buildConstraintExtractor(DatabaseType dt) {
        switch (dt) {
            case H2: {
                return new H2ConstraintExtractor();
            }
            case POSTGRES: {
                return new PostgresConstraintExtractor();
            }
            case MYSQL: {
                return new MySQLConstraintExtractor();
            }
            case DERBY: 
            case OTHER: {
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown database type " + (Object)((Object)dt));
    }
}

