/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.evomaster.client.java.instrumentation.JpaConstraint;
import org.evomaster.client.java.instrumentation.staticstate.UnitsInfoRecorder;
import org.evomaster.client.java.utils.SimpleLogger;

public class ClassAnalyzer {
    public static void doAnalyze(Collection<String> classNames) {
        boolean jpa = ClassAnalyzer.canUseJavaxJPA();
        for (String name : classNames) {
            Class<?> klass;
            try {
                ClassLoader loader = UnitsInfoRecorder.getInstance().getFirstClassLoader(name);
                if (loader == null) {
                    loader = ClassAnalyzer.class.getClassLoader();
                    SimpleLogger.warn("No class loader registered for " + name);
                }
                klass = loader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                SimpleLogger.error("Failed to load class " + name, e);
                continue;
            }
            try {
                if (!jpa) continue;
                ClassAnalyzer.analyzeJpaConstraints(klass);
            }
            catch (Exception e) {
                SimpleLogger.error("Failed to analyze " + name, e);
            }
        }
    }

    private static boolean canUseJavaxJPA() {
        try {
            ClassLoader loader = UnitsInfoRecorder.getInstance().getSutClassLoader();
            if (loader == null) {
                SimpleLogger.warn("No identified ClassLoader for SUT");
                loader = ClassAnalyzer.class.getClassLoader();
            }
            loader.loadClass("javax.persistence.Entity");
            loader.loadClass("javax.validation.constraints.NotNull");
            return true;
        }
        catch (ClassNotFoundException e) {
            SimpleLogger.info("Not analyzing JPA using javax package");
            return false;
        }
    }

    private static Annotation getAnnotationByName(Class<?> klass, String name) {
        return ClassAnalyzer.getAnnotationByName(klass.getAnnotations(), name);
    }

    private static Annotation getAnnotationByName(Field field, String name) {
        return ClassAnalyzer.getAnnotationByName(field.getAnnotations(), name);
    }

    private static Annotation getAnnotationByName(Annotation[] annotations, String name) {
        return Arrays.stream(annotations).filter(a -> a.annotationType().getName().equals(name)).findFirst().orElse(null);
    }

    private static String convertToSnakeCase(String s) {
        String regex = "([a-z])([A-Z]+)";
        String replacement = "$1_$2";
        return s.replaceAll(regex, replacement).toLowerCase();
    }

    private static void analyzeJpaConstraints(Class<?> klass) throws Exception {
        Annotation entity = ClassAnalyzer.getAnnotationByName(klass, "javax.persistence.Entity");
        if (entity == null) {
            return;
        }
        String entityName = (String)entity.getClass().getMethod("name", new Class[0]).invoke((Object)entity, new Object[0]);
        Annotation table = ClassAnalyzer.getAnnotationByName(klass, "javax.persistence.Table");
        String tableName = table != null ? (String)table.getClass().getMethod("name", new Class[0]).invoke((Object)table, new Object[0]) : (entityName != null && !entityName.isEmpty() ? entityName : klass.getSimpleName());
        tableName = ClassAnalyzer.convertToSnakeCase(tableName);
        for (Field f : klass.getDeclaredFields()) {
            Integer digitsFraction;
            Integer digitsInteger;
            Integer sizeMax;
            Integer sizeMin;
            String patternRegExp;
            String decimalMaxValue;
            if (Modifier.isStatic(f.getModifiers()) || ClassAnalyzer.getAnnotationByName(f, "javax.persistence.Transient") != null) continue;
            String columnName = null;
            Annotation column = ClassAnalyzer.getAnnotationByName(f, "javax.persistence.Column");
            if (column != null) {
                columnName = (String)column.getClass().getMethod("name", new Class[0]).invoke((Object)column, new Object[0]);
            }
            if (columnName == null || columnName.isEmpty()) {
                columnName = f.getName();
            }
            columnName = ClassAnalyzer.convertToSnakeCase(columnName);
            Boolean isNullable = ClassAnalyzer.getIsNullableAnnotation(f);
            List<String> enumValuesAsStrings = ClassAnalyzer.getEnumeratedAnnotation(f);
            Long minValue = ClassAnalyzer.getMinValue(f);
            Long maxValue = ClassAnalyzer.getMaxValue(f);
            Boolean isNotBlank = ClassAnalyzer.getIsNotBlank(f);
            Boolean isEmail = ClassAnalyzer.getEmail(f);
            Boolean isNegative = ClassAnalyzer.getNegative(f);
            Boolean isNegativeOrZero = ClassAnalyzer.getNegativeOrZero(f);
            Boolean isPositive = ClassAnalyzer.getPositive(f);
            Boolean isPositiveOrZero = ClassAnalyzer.getPositiveOrZero(f);
            Boolean isPast = ClassAnalyzer.getPast(f);
            Boolean isPastOrPresent = ClassAnalyzer.getPastOrPresent(f);
            Boolean isFuture = ClassAnalyzer.getFuture(f);
            Boolean isFutureOrPresent = ClassAnalyzer.getFutureOrPresent(f);
            Boolean isAlwaysNull = ClassAnalyzer.getNullAnnotation(f);
            Boolean isOptional = null;
            String decimalMinValue = ClassAnalyzer.getDecimalMinValue(f);
            JpaConstraint jpaConstraint = new JpaConstraint(tableName, columnName, isNullable, isOptional, minValue, maxValue, enumValuesAsStrings, decimalMinValue, decimalMaxValue = ClassAnalyzer.getDecimalMaxValue(f), isNotBlank, isEmail, isNegative, isNegativeOrZero, isPositive, isPositiveOrZero, isFuture, isFutureOrPresent, isPast, isPastOrPresent, isAlwaysNull, patternRegExp = ClassAnalyzer.getPatterRegExp(f), sizeMin = ClassAnalyzer.getSizeMin(f), sizeMax = ClassAnalyzer.getSizeMax(f), digitsInteger = ClassAnalyzer.getDigitsInteger(f), digitsFraction = ClassAnalyzer.getDigitsFraction(f));
            if (!jpaConstraint.isMeaningful()) continue;
            UnitsInfoRecorder.registerNewJpaConstraint(jpaConstraint);
        }
    }

    private static Long getMaxValue(Field f) throws Exception {
        return ClassAnalyzer.getLongElement(f, "javax.validation.constraints.Max", "value");
    }

    private static Long getMinValue(Field f) throws Exception {
        return ClassAnalyzer.getLongElement(f, "javax.validation.constraints.Min", "value");
    }

    private static String getDecimalMinValue(Field f) throws Exception {
        return ClassAnalyzer.getStringElement(f, "javax.validation.constraints.DecimalMin", "value");
    }

    private static String getDecimalMaxValue(Field f) throws Exception {
        return ClassAnalyzer.getStringElement(f, "javax.validation.constraints.DecimalMax", "value");
    }

    private static String getPatterRegExp(Field f) throws Exception {
        return ClassAnalyzer.getStringElement(f, "javax.validation.constraints.Pattern", "regexp");
    }

    private static Long getLongElement(Field f, String annotationName, String elementName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return (Long)ClassAnalyzer.getElement(f, annotationName, elementName);
    }

    private static String getStringElement(Field f, String annotationName, String elementName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return (String)ClassAnalyzer.getElement(f, annotationName, elementName);
    }

    private static Integer getIntegerElement(Field f, String annotationName, String elementName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return (Integer)ClassAnalyzer.getElement(f, annotationName, elementName);
    }

    private static Integer getSizeMin(Field f) throws Exception {
        return ClassAnalyzer.getIntegerElement(f, "javax.validation.constraints.Size", "min");
    }

    private static Integer getSizeMax(Field f) throws Exception {
        return ClassAnalyzer.getIntegerElement(f, "javax.validation.constraints.Size", "max");
    }

    private static Integer getDigitsInteger(Field f) throws Exception {
        return ClassAnalyzer.getIntegerElement(f, "javax.validation.constraints.Digits", "integer");
    }

    private static Integer getDigitsFraction(Field f) throws Exception {
        return ClassAnalyzer.getIntegerElement(f, "javax.validation.constraints.Digits", "fraction");
    }

    private static Object getElement(Field f, String annotationName, String elementName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Annotation annotation = ClassAnalyzer.getAnnotationByName(f, annotationName);
        if (annotation != null) {
            return annotation.getClass().getMethod(elementName, new Class[0]).invoke((Object)annotation, new Object[0]);
        }
        return null;
    }

    private static List<String> getEnumeratedAnnotation(Field f) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Annotation enumerated;
        List enumValuesAsStrings = null;
        if (f.getType().isEnum() && (enumerated = ClassAnalyzer.getAnnotationByName(f, "javax.persistence.Enumerated")) != null) {
            Object enumeratedValue = enumerated.getClass().getMethod("value", new Class[0]).invoke((Object)enumerated, new Object[0]);
            String enumTypeString = "STRING".toLowerCase();
            if (enumeratedValue.toString().toLowerCase().equals(enumTypeString)) {
                enumValuesAsStrings = Arrays.stream(f.getType().getEnumConstants()).map(Object::toString).collect(Collectors.toList());
            }
        }
        return enumValuesAsStrings;
    }

    private static Boolean getIsNullableAnnotation(Field f) {
        Boolean isNullable = f.getType().isPrimitive() || ClassAnalyzer.getAnnotationByName(f, "javax.validation.constraints.NotNull") != null ? Boolean.valueOf(false) : null;
        return isNullable;
    }

    private static Boolean getIsNotBlank(Field f) {
        return ClassAnalyzer.getIsAnnotationWith(f, "javax.validation.constraints.NotBlank");
    }

    private static Boolean getEmail(Field f) {
        return ClassAnalyzer.getIsAnnotationWith(f, "javax.validation.constraints.Email");
    }

    private static Boolean getPositive(Field f) {
        return ClassAnalyzer.getIsAnnotationWith(f, "javax.validation.constraints.Positive");
    }

    private static Boolean getPositiveOrZero(Field f) {
        return ClassAnalyzer.getIsAnnotationWith(f, "javax.validation.constraints.PositiveOrZero");
    }

    private static Boolean getNegative(Field f) {
        return ClassAnalyzer.getIsAnnotationWith(f, "javax.validation.constraints.Negative");
    }

    private static Boolean getNegativeOrZero(Field f) {
        return ClassAnalyzer.getIsAnnotationWith(f, "javax.validation.constraints.NegativeOrZero");
    }

    private static Boolean getPast(Field f) {
        return ClassAnalyzer.getIsAnnotationWith(f, "javax.validation.constraints.Past");
    }

    private static Boolean getPastOrPresent(Field f) {
        return ClassAnalyzer.getIsAnnotationWith(f, "javax.validation.constraints.PastOrPresent");
    }

    private static Boolean getFuture(Field f) {
        return ClassAnalyzer.getIsAnnotationWith(f, "javax.validation.constraints.Future");
    }

    private static Boolean getFutureOrPresent(Field f) {
        return ClassAnalyzer.getIsAnnotationWith(f, "javax.validation.constraints.FutureOrPresent");
    }

    private static Boolean getNullAnnotation(Field f) {
        return ClassAnalyzer.getIsAnnotationWith(f, "javax.validation.constraints.Null");
    }

    private static Boolean getIsAnnotationWith(Field f, String annotationName) {
        Boolean isAnnotated = ClassAnalyzer.getAnnotationByName(f, annotationName) != null ? Boolean.valueOf(true) : null;
        return isAnnotated;
    }
}

