/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.RegexDistanceUtils;
import org.evomaster.client.java.instrumentation.heuristic.Truthness;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.shared.StringSpecialization;
import org.evomaster.client.java.instrumentation.shared.StringSpecializationInfo;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class PatternMatchingHelper {
    private static final int DEFAULT_PATTERN_FLAGS = 0;

    public static boolean matches(String regex, String input, String idTemplate) {
        return PatternMatchingHelper.matches(regex, 0, input, idTemplate);
    }

    public static boolean matches(String regex, int flags, String input, String idTemplate) {
        Objects.requireNonNull(regex);
        Objects.requireNonNull(input);
        if (ExecutionTracer.isTaintInput(input)) {
            ExecutionTracer.addStringSpecialization(input, new StringSpecializationInfo(StringSpecialization.REGEX_WHOLE, regex));
        }
        Pattern p = Pattern.compile(regex, flags);
        Matcher m = p.matcher(input);
        boolean matches = m.matches();
        if (idTemplate == null) {
            return matches;
        }
        if (matches) {
            ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, new Truthness(1.0, 0.1));
        } else {
            int distance = RegexDistanceUtils.getStandardDistance(input, regex);
            ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, new Truthness(1.0 / (1.0 + (double)distance), 1.0));
        }
        return matches;
    }
}

