/*
 * Decompiled with CFR 0.152.
 */
package shaded.net.sf.jsqlparser.util.deparser;

import java.util.List;
import shaded.net.sf.jsqlparser.expression.Expression;
import shaded.net.sf.jsqlparser.expression.ExpressionVisitor;
import shaded.net.sf.jsqlparser.statement.SetStatement;
import shaded.net.sf.jsqlparser.util.deparser.AbstractDeParser;

public class SetStatementDeParser
extends AbstractDeParser<SetStatement> {
    private ExpressionVisitor expressionVisitor;

    public SetStatementDeParser(ExpressionVisitor expressionVisitor, StringBuilder buffer) {
        super(buffer);
        this.expressionVisitor = expressionVisitor;
    }

    @Override
    public void deParse(SetStatement set) {
        this.buffer.append("SET ");
        if (set.getEffectParameter() != null) {
            this.buffer.append(set.getEffectParameter()).append(" ");
        }
        for (int i = 0; i < set.getCount(); ++i) {
            if (i > 0) {
                this.buffer.append(", ");
            }
            this.buffer.append(set.getName(i));
            if (set.isUseEqual(i)) {
                this.buffer.append(" =");
            }
            this.buffer.append(" ");
            List<Expression> expressions = set.getExpressions(i);
            for (int j = 0; j < expressions.size(); ++j) {
                if (j > 0) {
                    this.buffer.append(", ");
                }
                expressions.get(j).accept(this.expressionVisitor);
            }
        }
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor visitor) {
        this.expressionVisitor = visitor;
    }
}

