/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc.schema.params;

import java.util.ArrayList;
import java.util.List;
import org.evomaster.client.java.controller.api.dto.problem.rpc.ParamDto;
import org.evomaster.client.java.controller.api.dto.problem.rpc.RPCSupportedDataType;
import org.evomaster.client.java.controller.problem.rpc.CodeJavaOrKotlinGenerator;
import org.evomaster.client.java.controller.problem.rpc.schema.params.PrimitiveOrWrapperParam;
import org.evomaster.client.java.controller.problem.rpc.schema.types.AccessibleSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.types.JavaDtoSpec;
import org.evomaster.client.java.controller.problem.rpc.schema.types.PrimitiveOrWrapperType;

public class FloatParam
extends PrimitiveOrWrapperParam<Float> {
    private static final String JAVA_PR_METHOD = "floatValue";
    private static final String KOTLIN_PR_METHOD = "toFloat";

    public FloatParam(String name, String type, String fullTypeName, Class<?> clazz, AccessibleSchema accessibleSchema, JavaDtoSpec spec) {
        super(name, type, fullTypeName, clazz, accessibleSchema, spec);
    }

    public FloatParam(String name, PrimitiveOrWrapperType type, AccessibleSchema accessibleSchema) {
        super(name, type, accessibleSchema);
    }

    @Override
    public String getValueAsJavaString(boolean isJava) {
        if (this.getValue() == null) {
            return null;
        }
        return "" + this.getValue() + "f";
    }

    @Override
    public ParamDto getDto() {
        ParamDto dto = super.getDto();
        dto.type.type = ((PrimitiveOrWrapperType)this.getType()).isWrapper ? RPCSupportedDataType.FLOAT : RPCSupportedDataType.P_FLOAT;
        if (this.getValue() != null) {
            dto.stringValue = ((Float)this.getValue()).toString();
        }
        return dto;
    }

    public FloatParam copyStructure() {
        return new FloatParam(this.getName(), (PrimitiveOrWrapperType)this.getType(), this.accessibleSchema);
    }

    @Override
    public void setValueBasedOnStringValue(String stringValue) {
        try {
            if (stringValue != null) {
                this.setValue(Float.valueOf(Float.parseFloat(stringValue)));
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("ERROR: fail to convert " + stringValue + " as float value");
        }
    }

    @Override
    protected void setValueBasedOnValidInstance(Object instance) {
        this.setValue((Float)instance);
    }

    @Override
    public boolean isValidInstance(Object instance) {
        return instance instanceof Float;
    }

    @Override
    public List<String> newAssertionWithJavaOrKotlin(int indent, String responseVarName, int maxAssertionForDataInCollection, boolean isJava) {
        if (this.getValue() == null) {
            return super.newAssertionWithJavaOrKotlin(indent, responseVarName, maxAssertionForDataInCollection, isJava);
        }
        ArrayList<String> codes = new ArrayList<String>();
        if (((Float)this.getValue()).isInfinite() || ((Float)this.getValue()).isNaN()) {
            CodeJavaOrKotlinGenerator.addComment(codes, "// " + responseVarName + " is " + this.getValueAsJavaString(isJava), indent);
        } else {
            CodeJavaOrKotlinGenerator.addCode(codes, CodeJavaOrKotlinGenerator.junitAssertNumbersMatch(this.getValueAsJavaString(isJava), responseVarName, isJava), indent);
        }
        return codes;
    }

    @Override
    public String primitiveValueMethod(boolean isJava) {
        if (isJava) {
            return JAVA_PR_METHOD;
        }
        return KOTLIN_PR_METHOD;
    }
}

