/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.ThirdPartyCast;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.ThirdPartyMethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.UsageFilter;
import org.evomaster.client.java.instrumentation.shared.ClassName;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.utils.SimpleLogger;
import shaded.org.objectweb.asm.Type;

public class ReplacementUtils {
    public static String getDescriptor(Method m, int skipFirsts, int skipLast) {
        return ReplacementUtils.getDescriptor(m, skipFirsts, skipLast, Type.getDescriptor(m.getReturnType()), false);
    }

    public static String getDescriptor(Method m, int skipFirsts, int skipLast, boolean applyThirdPartyCast) {
        Replacement r;
        String returnType = Type.getDescriptor(m.getReturnType());
        if (applyThirdPartyCast && !(r = m.getAnnotation(Replacement.class)).castTo().isEmpty() && !r.replacingConstructor()) {
            returnType = ReplacementUtils.getDescriptorForClassName(r.castTo());
        }
        return ReplacementUtils.getDescriptor(m, skipFirsts, skipLast, returnType, applyThirdPartyCast);
    }

    private static String getDescriptorForClassName(String className) {
        return "L" + className.replace(".", "/") + ";";
    }

    private static String getDescriptor(Method m, int skipFirsts, int skipLast, String returnType, boolean applyThirdPartyCast) {
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        Class<?>[] parameters = m.getParameterTypes();
        Annotation[][] annotations = m.getParameterAnnotations();
        int start = skipFirsts;
        int end = parameters.length - skipLast;
        for (int i = start; i < end; ++i) {
            Class<?> t = parameters[i];
            ThirdPartyCast tpc = ReplacementUtils.getThirdPartyCast(annotations[i]);
            if (applyThirdPartyCast && tpc != null) {
                buf.append(ReplacementUtils.getDescriptorForClassName(tpc.actualType().trim()));
                continue;
            }
            buf.append(Type.getDescriptor(t));
        }
        buf.append(')');
        buf.append(returnType);
        return buf.toString();
    }

    public static List<Class<?>> getParameterTypes(Method m, int skipFirsts, int skipLast, boolean applyThirdPartyCast) {
        Class<?>[] parameters = m.getParameterTypes();
        Annotation[][] annotations = m.getParameterAnnotations();
        int start = skipFirsts;
        int end = parameters.length - skipLast;
        ArrayList types = new ArrayList(end - start + 1);
        for (int i = start; i < end; ++i) {
            Class<?> t = parameters[i];
            if (applyThirdPartyCast) {
                ThirdPartyCast tpc = ReplacementUtils.getThirdPartyCast(annotations[i]);
                Class<?> casted = ReplacementUtils.getCastedToThirdParty(ReplacementUtils.class.getClassLoader(), annotations[i]);
                if (casted != null) {
                    t = casted;
                } else if (tpc != null) {
                    throw new IllegalStateException("BUG: this code should not be called outside tests, as would not work");
                }
            }
            types.add(t);
        }
        return types;
    }

    public static ThirdPartyCast getThirdPartyCast(Annotation[] annotations) {
        return Arrays.stream(annotations).filter(a -> a instanceof ThirdPartyCast).findFirst().orElse(null);
    }

    public static Class<?> getCastedToThirdParty(ClassLoader loader, Annotation[] annotations) {
        ThirdPartyCast thirdPartyCast = ReplacementUtils.getThirdPartyCast(annotations);
        if (thirdPartyCast != null) {
            return ReplacementUtils.loadClass(loader, thirdPartyCast.actualType().trim());
        }
        return null;
    }

    private static Class<?> loadClass(ClassLoader loader, String className) {
        try {
            return loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            SimpleLogger.error("Cannot load third-party cast class: " + className, e);
            return null;
        }
    }

    public static String getPossiblyModifiedName(Method m) {
        String replacementName = m.getName();
        if (ThirdPartyCast.NAME_REGEX.matcher(replacementName).matches()) {
            if (!ThirdPartyMethodReplacementClass.class.isAssignableFrom(m.getDeclaringClass())) {
                throw new IllegalArgumentException("Modified names are only used for ThirdPartyMethodReplacementClass subclasses");
            }
            replacementName = replacementName.split("_EM_")[0];
        }
        return replacementName;
    }

    public static Optional<Method> chooseMethodFromCandidateReplacement(boolean isInSUT, String name, String desc, List<MethodReplacementClass> candidateClasses, boolean requirePure, String contextClassName) {
        Optional<Method> r = candidateClasses.stream().filter(i -> {
            try {
                i.getClass().getDeclaredMethods();
                return true;
            }
            catch (Throwable t) {
                String msg = "FAILED TO LOAD METHOD DECLARATIONS FOR: " + i.getClass().getName();
                SimpleLogger.error(msg);
                return false;
            }
        }).flatMap(i -> Stream.of(i.getClass().getDeclaredMethods())).filter(m -> m.getDeclaredAnnotation(Replacement.class) != null).filter(m -> {
            boolean isConstructor;
            Replacement br = m.getAnnotation(Replacement.class);
            if (isInSUT && br.usageFilter() == UsageFilter.ONLY_THIRD_PARTY) {
                return false;
            }
            if (!isInSUT && br.usageFilter() == UsageFilter.ONLY_SUT) {
                String ctx = ClassName.get(contextClassName).getFullNameWithDots();
                if (br.extraPackagesToConsider().length == 0 || Arrays.stream(br.packagesToSkip()).noneMatch(it -> ctx.startsWith((String)it))) {
                    return false;
                }
            }
            if (requirePure && !br.isPure()) {
                return false;
            }
            String ctg = br.category().toString();
            String categories = System.getProperty("evomaster.javaagent.replacement_categories");
            if (categories == null || !Arrays.stream(categories.split(",")).anyMatch(c -> c.equals(ctg))) {
                return false;
            }
            if (br.packagesToSkip().length > 0 && contextClassName != null) {
                String ctx = ClassName.get(contextClassName).getFullNameWithDots();
                if (Arrays.stream(br.packagesToSkip()).anyMatch(it -> ctx.startsWith((String)it) || it.startsWith(".") && ctx.contains((CharSequence)it))) {
                    return false;
                }
            }
            if (isConstructor = name.equals("<init>")) {
                int skipFirst = 0;
                int skipLast = br.type() == ReplacementType.TRACKER ? 0 : 1;
                return desc.equals(ReplacementUtils.getDescriptor(m, skipFirst, skipLast, true));
            }
            String replacementName = ReplacementUtils.getPossiblyModifiedName(m);
            if (!replacementName.equals(name)) {
                return false;
            }
            int skipFirst = br.replacingStatic() ? 0 : 1;
            int skipLast = br.type() == ReplacementType.TRACKER ? 0 : 1;
            return desc.equals(ReplacementUtils.getDescriptor(m, skipFirst, skipLast, true));
        }).findAny();
        return r;
    }
}

