/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.internal;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import org.evomaster.client.java.controller.api.dto.database.schema.DbSchemaDto;
import org.evomaster.client.java.distance.heuristics.DistanceHelper;
import org.evomaster.client.java.sql.DataRow;
import org.evomaster.client.java.sql.QueryResult;
import org.evomaster.client.java.sql.internal.ParserUtils;
import org.evomaster.client.java.sql.internal.SqlDistanceWithMetrics;
import org.evomaster.client.java.sql.internal.SqlNameContext;
import org.evomaster.client.java.sql.internal.TaintHandler;
import org.evomaster.client.java.utils.SimpleLogger;
import shaded.net.sf.jsqlparser.expression.CastExpression;
import shaded.net.sf.jsqlparser.expression.DateTimeLiteralExpression;
import shaded.net.sf.jsqlparser.expression.DoubleValue;
import shaded.net.sf.jsqlparser.expression.Expression;
import shaded.net.sf.jsqlparser.expression.LongValue;
import shaded.net.sf.jsqlparser.expression.NullValue;
import shaded.net.sf.jsqlparser.expression.Parenthesis;
import shaded.net.sf.jsqlparser.expression.SignedExpression;
import shaded.net.sf.jsqlparser.expression.StringValue;
import shaded.net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import shaded.net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import shaded.net.sf.jsqlparser.expression.operators.relational.Between;
import shaded.net.sf.jsqlparser.expression.operators.relational.ComparisonOperator;
import shaded.net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import shaded.net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import shaded.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import shaded.net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import shaded.net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import shaded.net.sf.jsqlparser.expression.operators.relational.InExpression;
import shaded.net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import shaded.net.sf.jsqlparser.expression.operators.relational.JsonOperator;
import shaded.net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import shaded.net.sf.jsqlparser.expression.operators.relational.Matches;
import shaded.net.sf.jsqlparser.expression.operators.relational.MinorThan;
import shaded.net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import shaded.net.sf.jsqlparser.expression.operators.relational.NamedExpressionList;
import shaded.net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import shaded.net.sf.jsqlparser.expression.operators.relational.RegExpMatchOperator;
import shaded.net.sf.jsqlparser.schema.Column;
import shaded.net.sf.jsqlparser.statement.Statement;

public class HeuristicsCalculator {
    private static final String QUOTE = "'";
    private final SqlNameContext context;
    private final TaintHandler taintHandler;
    private final boolean advancedHeuristics;

    protected HeuristicsCalculator(SqlNameContext context, TaintHandler handler, boolean advancedHeuristics) {
        this.context = Objects.requireNonNull(context);
        this.taintHandler = handler;
        this.advancedHeuristics = advancedHeuristics;
    }

    protected static double computeDistance(String statement, QueryResult data) {
        return HeuristicsCalculator.computeDistance((String)statement, (QueryResult)data, null, null, (boolean)false).sqlDistance;
    }

    public static SqlDistanceWithMetrics computeDistance(String statement, QueryResult data, DbSchemaDto schema, TaintHandler taintHandler, boolean advancedHeuristics) {
        if (data.isEmpty()) {
            return new SqlDistanceWithMetrics(Double.MAX_VALUE, 0);
        }
        Statement stmt = ParserUtils.asStatement(statement);
        Expression where = ParserUtils.getWhere(stmt);
        if (where == null) {
            return new SqlDistanceWithMetrics(0.0, 0);
        }
        SqlNameContext context = new SqlNameContext(stmt);
        if (schema != null) {
            context.setSchema(schema);
        }
        HeuristicsCalculator calculator = new HeuristicsCalculator(context, taintHandler, advancedHeuristics);
        double minSqlDistance = Double.MAX_VALUE;
        int rowCount = 0;
        for (DataRow row : data.seeRows()) {
            ++rowCount;
            try {
                double dist = calculator.computeExpression(where, row);
                if (dist == 0.0) {
                    return new SqlDistanceWithMetrics(0.0, rowCount);
                }
                if (!(dist < minSqlDistance)) continue;
                minSqlDistance = dist;
            }
            catch (Exception ex) {
                SimpleLogger.uniqueWarn("Failed to compute where expression: " + where + " with data " + row);
                return new SqlDistanceWithMetrics(Double.MAX_VALUE, rowCount);
            }
        }
        return new SqlDistanceWithMetrics(minSqlDistance, rowCount);
    }

    private double computeExpression(Expression exp, DataRow data) {
        if (exp instanceof Parenthesis) {
            return this.computeExpression(((Parenthesis)exp).getExpression(), data);
        }
        if (exp instanceof AndExpression) {
            return this.computeAnd((AndExpression)exp, data);
        }
        if (exp instanceof OrExpression) {
            return this.computeOr((OrExpression)exp, data);
        }
        if (exp instanceof Between) {
            return this.computeBetween((Between)exp, data);
        }
        if (exp instanceof ComparisonOperator) {
            return this.computeComparisonOperator((ComparisonOperator)exp, data);
        }
        if (exp instanceof InExpression) {
            return this.computeInExpression((InExpression)exp, data);
        }
        if (exp instanceof IsNullExpression) {
            return this.computeIsNull((IsNullExpression)exp, data);
        }
        if (exp instanceof ExistsExpression) {
            // empty if block
        }
        if (exp instanceof ExpressionList) {
            // empty if block
        }
        if (exp instanceof JsonOperator) {
            // empty if block
        }
        if (exp instanceof LikeExpression) {
            // empty if block
        }
        if (exp instanceof Matches) {
            // empty if block
        }
        if (exp instanceof ExpressionList) {
            // empty if block
        }
        if (exp instanceof NamedExpressionList) {
            // empty if block
        }
        if (exp instanceof RegExpMatchOperator) {
            // empty if block
        }
        return this.cannotHandle(exp);
    }

    private double computeBetween(Between between, DataRow data) {
        Instant start = this.getAsInstant(this.getValue(between.getBetweenExpressionStart(), data));
        Instant end = this.getAsInstant(this.getValue(between.getBetweenExpressionEnd(), data));
        Instant x = this.getAsInstant(this.getValue(between.getLeftExpression(), data));
        double after = this.computeComparison(x, start, (ComparisonOperator)new GreaterThanEquals());
        double before = this.computeComparison(x, end, (ComparisonOperator)new MinorThanEquals());
        return DistanceHelper.addDistances(after, before);
    }

    private double computeInExpression(InExpression exp, DataRow data) {
        Expression rightExpression = exp.getRightExpression();
        if (rightExpression instanceof ExpressionList) {
            ExpressionList expressionList = (ExpressionList)rightExpression;
            if (exp.isNot()) {
                double max = 0.0;
                for (Expression element : expressionList) {
                    NotEqualsTo op = new NotEqualsTo();
                    op.setLeftExpression(exp.getLeftExpression());
                    op.setRightExpression(element);
                    double dist = this.computeComparisonOperator(op, data);
                    if (!(dist > max)) continue;
                    max = dist;
                    break;
                }
                return max;
            }
            double min = Double.MAX_VALUE;
            for (Expression element : expressionList) {
                EqualsTo op = new EqualsTo();
                op.setLeftExpression(exp.getLeftExpression());
                op.setRightExpression(element);
                double dist = this.computeComparisonOperator(op, data);
                if (!(dist < min)) continue;
                min = dist;
            }
            return min;
        }
        return this.cannotHandle(exp);
    }

    private double computeIsNull(IsNullExpression exp, DataRow data) {
        Object x = this.getValue(exp.getLeftExpression(), data);
        if (x == null && !exp.isNot()) {
            return 0.0;
        }
        if (x != null && exp.isNot()) {
            return 0.0;
        }
        return 1.0;
    }

    private double cannotHandle(Expression exp) {
        SimpleLogger.uniqueWarn("WARNING, cannot handle SQL expression type '" + exp.getClass().getSimpleName() + "' with value: " + exp);
        return Double.MAX_VALUE;
    }

    private double computeAnd(AndExpression exp, DataRow data) {
        double a = this.computeExpression(exp.getLeftExpression(), data);
        double b = this.computeExpression(exp.getRightExpression(), data);
        return DistanceHelper.addDistances(a / 2.0, b / 2.0);
    }

    private double computeOr(OrExpression exp, DataRow data) {
        double a = this.computeExpression(exp.getLeftExpression(), data);
        double b = this.computeExpression(exp.getRightExpression(), data);
        return Math.min(a, b);
    }

    protected Instant getAsInstant(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)obj;
            return timestamp.toInstant();
        }
        if (obj instanceof String) {
            List<Function> parsers = Arrays.asList(s -> ZonedDateTime.parse(s).toInstant(), Instant::parse, s -> OffsetDateTime.parse(s, DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss.SSSX")).toInstant(), s -> {
                DateTimeFormatter df = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("dd-MMM-yy").toFormatter(Locale.ENGLISH);
                return LocalDate.parse(obj.toString(), df).atStartOfDay().toInstant(ZoneOffset.UTC);
            }, s -> {
                try {
                    return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSS").parse((String)s).toInstant();
                }
                catch (ParseException ex) {
                    throw new DateTimeParseException("Cannot parse to yyyy-MM-dd HH:mm:ss.SSSS", (CharSequence)s, ex.getErrorOffset(), ex);
                }
            });
            String s2 = obj.toString();
            for (Function p : parsers) {
                try {
                    return (Instant)p.apply(s2);
                }
                catch (DateTimeParseException dateTimeParseException) {
                }
            }
            SimpleLogger.warn("Cannot handle time value in the format: " + s2);
            return null;
        }
        SimpleLogger.warn("Cannot handle time value for class: " + obj.getClass());
        return null;
    }

    private double computeComparisonOperator(ComparisonOperator exp, DataRow data) {
        Object left = this.getValue(exp.getLeftExpression(), data);
        Object right = this.getValue(exp.getRightExpression(), data);
        if (left instanceof Timestamp || right instanceof Timestamp) {
            Instant a = this.getAsInstant(left);
            Instant b = this.getAsInstant(right);
            if (a == null || b == null) {
                return this.cannotHandle(exp);
            }
            return this.computeComparison(a, b, exp);
        }
        if (left instanceof Number && right instanceof Number) {
            double x = ((Number)left).doubleValue();
            double y = ((Number)right).doubleValue();
            return this.computerComparison(x, y, exp);
        }
        if (left instanceof String && right instanceof String) {
            return this.computeComparison(left.toString(), right.toString(), exp);
        }
        if (left instanceof Boolean && right instanceof Boolean) {
            return this.computeBooleanComparison((Boolean)left, (Boolean)right, exp);
        }
        if (left == null || right == null) {
            return this.computeNullComparison(left, right, exp);
        }
        return this.cannotHandle(exp);
    }

    private double computeComparison(Instant a, Instant b, ComparisonOperator exp) {
        if (a == null || b == null) {
            return Double.MAX_VALUE;
        }
        double dif = -Duration.between(a, b).toMillis();
        return this.computerComparison(dif, exp);
    }

    private double computeBooleanComparison(boolean x, boolean y, ComparisonOperator exp) {
        if (!this.checkEqualOrNotOperator(exp)) {
            return this.cannotHandle(exp);
        }
        if (exp instanceof EqualsTo && x == y) {
            return 0.0;
        }
        if (exp instanceof NotEqualsTo && x != y) {
            return 0.0;
        }
        return 1.0;
    }

    private boolean checkEqualOrNotOperator(ComparisonOperator exp) {
        return exp instanceof EqualsTo || exp instanceof NotEqualsTo;
    }

    private double computeNullComparison(Object left, Object right, ComparisonOperator exp) {
        assert (left == null || right == null);
        if (!this.checkEqualOrNotOperator(exp)) {
            return this.cannotHandle(exp);
        }
        if (exp instanceof EqualsTo && left == right) {
            return 0.0;
        }
        if (exp instanceof NotEqualsTo && left != right) {
            return 0.0;
        }
        return Double.MAX_VALUE;
    }

    private double computerComparison(double dif, ComparisonOperator exp) {
        if (exp instanceof EqualsTo) {
            return Math.abs(dif);
        }
        if (exp instanceof GreaterThanEquals) {
            return dif >= 0.0 ? 0.0 : -dif;
        }
        if (exp instanceof GreaterThan) {
            return dif > 0.0 ? 0.0 : 1.0 - dif;
        }
        if (exp instanceof MinorThanEquals) {
            return dif <= 0.0 ? 0.0 : dif;
        }
        if (exp instanceof MinorThan) {
            return dif < 0.0 ? 0.0 : 1.0 + dif;
        }
        if (exp instanceof NotEqualsTo) {
            return dif != 0.0 ? 0.0 : 1.0;
        }
        return this.cannotHandle(exp);
    }

    private double computerComparison(double x, double y, ComparisonOperator exp) {
        double dif = x - y;
        return this.computerComparison(dif, exp);
    }

    private double computeComparison(String a, String b, ComparisonOperator exp) {
        if (exp instanceof EqualsTo) {
            if (this.taintHandler != null) {
                this.taintHandler.handleTaintForStringEquals(a, b, false);
            }
            return DistanceHelper.getLeftAlignmentDistance(a, b);
        }
        if (exp instanceof NotEqualsTo) {
            if (a.equals(b)) {
                return Double.MAX_VALUE;
            }
            return 0.0;
        }
        return this.cannotHandle(exp);
    }

    private Object getValue(Expression exp, DataRow data) {
        if (exp instanceof Column) {
            Column column = (Column)exp;
            String name = column.getColumnName();
            String table = this.context.getTableName(column);
            return data.getValueByName(name, table);
        }
        if (exp instanceof Parenthesis) {
            return this.getValue(((Parenthesis)exp).getExpression(), data);
        }
        if (exp instanceof LongValue) {
            return ((LongValue)exp).getValue();
        }
        if (exp instanceof DoubleValue) {
            return ((DoubleValue)exp).getValue();
        }
        if (exp instanceof StringValue) {
            return ((StringValue)exp).getNotExcapedValue();
        }
        if (exp instanceof NullValue) {
            return null;
        }
        if (exp instanceof SignedExpression) {
            SignedExpression signed = (SignedExpression)exp;
            Object base = this.getValue(signed.getExpression(), data);
            if (signed.getSign() != '-') {
                return base;
            }
            if (base instanceof Long) {
                return -((Long)base).longValue();
            }
            if (base instanceof Double) {
                return -((Double)base).doubleValue();
            }
            if (base instanceof Float) {
                return Float.valueOf(-((Float)base).floatValue());
            }
            if (base instanceof Integer) {
                return -((Integer)base).intValue();
            }
            this.cannotHandle(exp);
            return null;
        }
        if (exp instanceof CastExpression) {
            CastExpression castExpression = (CastExpression)exp;
            return this.getValue(castExpression.getLeftExpression(), data);
        }
        if (exp instanceof DateTimeLiteralExpression) {
            DateTimeLiteralExpression dateTimeLiteralExpression = (DateTimeLiteralExpression)exp;
            String str = dateTimeLiteralExpression.getValue();
            assert (str.length() > 2 && this.startsAndEndsWithQuotes(str));
            str = this.removeFirstAndLastCharacter(str);
            return str;
        }
        this.cannotHandle(exp);
        return null;
    }

    private String removeFirstAndLastCharacter(String str) {
        if (str.length() < 2) {
            throw new IllegalArgumentException("Cannot remove quotes from " + str);
        }
        return str.substring(1, str.length() - 1);
    }

    private boolean startsAndEndsWithQuotes(String str) {
        return str.startsWith(QUOTE) && str.endsWith(QUOTE);
    }
}

