/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.evomaster.client.java.controller.api.dto.database.schema.DbSchemaDto;
import shaded.net.sf.jsqlparser.expression.Alias;
import shaded.net.sf.jsqlparser.schema.Column;
import shaded.net.sf.jsqlparser.schema.Table;
import shaded.net.sf.jsqlparser.statement.Statement;
import shaded.net.sf.jsqlparser.statement.delete.Delete;
import shaded.net.sf.jsqlparser.statement.select.FromItem;
import shaded.net.sf.jsqlparser.statement.select.FromItemVisitorAdapter;
import shaded.net.sf.jsqlparser.statement.select.Join;
import shaded.net.sf.jsqlparser.statement.select.ParenthesedSelect;
import shaded.net.sf.jsqlparser.statement.select.PlainSelect;
import shaded.net.sf.jsqlparser.statement.select.Select;
import shaded.net.sf.jsqlparser.statement.update.Update;

public class SqlNameContext {
    private DbSchemaDto schema = null;
    private final Map<String, String> tableAliases = new HashMap<String, String>();
    private final Statement statement;
    public static final String UNNAMED_TABLE = "___unnamed_table___";

    public SqlNameContext(Statement statement) {
        this.statement = Objects.requireNonNull(statement);
        this.computeAliases();
    }

    public void setSchema(DbSchemaDto schema) {
        this.schema = Objects.requireNonNull(schema);
    }

    public boolean hasColumn(String tableName, String columnName) {
        Objects.requireNonNull(tableName);
        Objects.requireNonNull(columnName);
        if (this.schema == null) {
            return false;
        }
        return this.schema.tables.stream().filter(t -> t.name.equalsIgnoreCase(tableName)).flatMap(t -> t.columns.stream()).filter(c -> c.name.equalsIgnoreCase(columnName)).count() > 0L;
    }

    public String getTableName(Column column) {
        Table table = column.getTable();
        if (table != null) {
            return this.tableAliases.getOrDefault(table.getName().toLowerCase(), table.getName().toLowerCase());
        }
        if (this.statement instanceof Select) {
            List<String> candidates = this.getTableNamesInFrom();
            assert (!candidates.isEmpty());
            if (candidates.size() == 1) {
                return candidates.get(0);
            }
            throw new IllegalArgumentException("TODO ambiguity");
        }
        if (this.statement instanceof Delete) {
            Delete delete = (Delete)this.statement;
            return delete.getTable().getName().toLowerCase();
        }
        if (this.statement instanceof Update) {
            Update update = (Update)this.statement;
            return update.getTable().getName().toLowerCase();
        }
        throw new IllegalArgumentException("Cannot handle table name for: " + this.statement);
    }

    private List<String> getTableNamesInFrom() {
        FromItem fromItem = this.getFromItem();
        final ArrayList<String> names = new ArrayList<String>();
        FromItemVisitorAdapter visitor = new FromItemVisitorAdapter(){

            @Override
            public void visit(Table table) {
                names.add(table.getName().toLowerCase());
            }
        };
        fromItem.accept(visitor);
        return names;
    }

    private FromItem getFromItem() {
        FromItem fromItem = null;
        if (this.statement instanceof Select) {
            Select select = (Select)this.statement;
            PlainSelect plainSelect = select.getPlainSelect();
            fromItem = plainSelect.getFromItem();
        }
        if (fromItem == null) {
            throw new IllegalArgumentException("Cannot handle FromItem for: " + this.statement);
        }
        return fromItem;
    }

    private void computeAliases() {
        if (this.statement instanceof Select) {
            FromItem fromItem = this.getFromItem();
            fromItem.accept(new AliasVisitor(this.tableAliases));
            Select select = (Select)this.statement;
            PlainSelect plainSelect = select.getPlainSelect();
            List<Join> joins = plainSelect.getJoins();
            if (joins != null) {
                joins.forEach(j -> j.getRightItem().accept(new AliasVisitor(this.tableAliases)));
            }
        } else {
            if (this.statement instanceof Delete) {
                return;
            }
            if (this.statement instanceof Update) {
                return;
            }
        }
    }

    private static void handleAlias(Map<String, String> aliases, PlainSelect plainSelect) {
        String aliasName;
        Alias alias = plainSelect.getFromItem().getAlias();
        if (alias != null && (aliasName = alias.getName()) != null) {
            String tableName = UNNAMED_TABLE;
            aliases.put(aliasName.trim().toLowerCase(), tableName.trim().toLowerCase());
        }
    }

    private static void handleAlias(Map<String, String> aliases, Table table) {
        String aliasName;
        Alias alias = table.getAlias();
        if (alias != null && (aliasName = alias.getName()) != null) {
            String tableName = table.getName().toLowerCase();
            aliases.put(aliasName.trim().toLowerCase(), tableName.trim().toLowerCase());
        }
    }

    private static class AliasVisitor
    extends FromItemVisitorAdapter {
        private final Map<String, String> aliases;

        private AliasVisitor(Map<String, String> aliases) {
            this.aliases = aliases;
        }

        @Override
        public void visit(Table table) {
            SqlNameContext.handleAlias((Map<String, String>)this.aliases, table);
        }

        @Override
        public void visit(ParenthesedSelect selectBody) {
            SqlNameContext.handleAlias((Map<String, String>)this.aliases, selectBody.getPlainSelect());
        }
    }
}

