/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import org.evomaster.client.java.controller.api.dto.auth.AuthenticationDto;
import org.evomaster.client.java.controller.api.dto.auth.HeaderDto;
import org.evomaster.client.java.controller.api.dto.auth.HttpVerb;
import org.evomaster.client.java.controller.api.dto.auth.LoginEndpointDto;
import org.evomaster.client.java.controller.api.dto.auth.TokenHandlingDto;

public class AuthUtils {
    public static String encode64(String value) {
        Objects.requireNonNull(value);
        byte[] data = value.getBytes(StandardCharsets.UTF_8);
        byte[] encoded = Base64.getEncoder().encode(data);
        return new String(encoded);
    }

    public static AuthenticationDto getForBasic(String dtoName, String userId, String password) {
        Objects.requireNonNull(userId, password);
        String encoded = AuthUtils.encode64(userId + ":" + password);
        String headerValue = "Basic " + encoded;
        return AuthUtils.getForAuthorizationHeader(dtoName, headerValue);
    }

    public static AuthenticationDto getForAuthorizationHeader(String dtoName, String authorizationValue) {
        AuthenticationDto dto = new AuthenticationDto(dtoName);
        dto.fixedHeaders.add(new HeaderDto("Authorization", authorizationValue));
        return dto;
    }

    public static AuthenticationDto getForDefaultSpringFormLogin(String dtoName, String username, String password) {
        LoginEndpointDto cookie = new LoginEndpointDto();
        cookie.endpoint = "/login";
        cookie.verb = HttpVerb.POST;
        cookie.contentType = "application/x-www-form-urlencoded";
        cookie.expectCookies = true;
        try {
            String usernameField = URLEncoder.encode("username", "UTF-8");
            String passwordField = URLEncoder.encode("password", "UTF-8");
            String payload = usernameField + "=" + URLEncoder.encode(username, "UTF-8");
            payload = payload + "&";
            cookie.payloadRaw = payload = payload + passwordField + "=" + URLEncoder.encode(password, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        AuthenticationDto dto = new AuthenticationDto(dtoName);
        dto.loginEndpointAuth = cookie;
        return dto;
    }

    public static AuthenticationDto getForJWT(String dtoName, String postEndpoint, String payload, String extractFromField) {
        return AuthUtils.getForJsonToken(dtoName, postEndpoint, payload, extractFromField, "JWT ");
    }

    public static AuthenticationDto getForJsonTokenBearer(String dtoName, String postEndpoint, String payload, String extractFromField) {
        return AuthUtils.getForJsonToken(dtoName, postEndpoint, payload, extractFromField, "Bearer ");
    }

    public static AuthenticationDto getForJsonToken(String dtoName, String postEndpoint, String payload, String extractFromField, String headerPrefix) {
        LoginEndpointDto le = new LoginEndpointDto();
        le.endpoint = postEndpoint;
        le.verb = HttpVerb.POST;
        le.contentType = "application/json";
        le.expectCookies = false;
        le.payloadRaw = payload;
        le.token = new TokenHandlingDto();
        le.token.extractFromField = extractFromField;
        le.token.headerPrefix = headerPrefix;
        le.token.httpHeaderName = "Authorization";
        AuthenticationDto dto = new AuthenticationDto(dtoName);
        dto.loginEndpointAuth = le;
        return dto;
    }
}

