/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.mongo.selectors;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evomaster.client.java.controller.mongo.QueryParser;
import org.evomaster.client.java.controller.mongo.operations.AndOperation;
import org.evomaster.client.java.controller.mongo.operations.EqualsOperation;
import org.evomaster.client.java.controller.mongo.operations.QueryOperation;
import org.evomaster.client.java.controller.mongo.selectors.QuerySelector;
import org.evomaster.client.java.controller.mongo.utils.BsonHelper;

public class ImplicitSelector
extends QuerySelector {
    @Override
    public QueryOperation getOperation(Object query) {
        if (!this.isUniqueEntry((Map)query).booleanValue()) {
            List<QueryOperation> conditions = this.parseConditions(query);
            return conditions.isEmpty() ? null : new AndOperation(conditions);
        }
        String fieldName = this.extractFieldName(query);
        return new EqualsOperation<Object>(fieldName, BsonHelper.getValue(query, fieldName));
    }

    protected List<QueryOperation> parseConditions(Object query) {
        Set<String> fields = BsonHelper.keySet(query);
        ArrayList<QueryOperation> conditions = new ArrayList<QueryOperation>();
        fields.forEach(fieldName -> {
            Object newQuery = BsonHelper.newDocument(query);
            BsonHelper.appendToDocument(newQuery, fieldName, BsonHelper.getValue(query, fieldName));
            conditions.add(new QueryParser().parse(newQuery));
        });
        return conditions;
    }

    @Override
    protected String extractOperator(Object query) {
        return "";
    }

    @Override
    protected String operator() {
        return "";
    }

    private String extractFieldName(Object query) {
        Set<String> keys = BsonHelper.documentKeys(query);
        return keys.stream().findFirst().orElse(null);
    }
}

