/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Map;
import org.evomaster.client.java.controller.api.dto.ActionResponseDto;
import org.evomaster.client.java.controller.api.dto.problem.rpc.RPCExceptionInfoDto;
import org.evomaster.client.java.controller.api.dto.problem.rpc.RPCType;
import org.evomaster.client.java.controller.api.dto.problem.rpc.exception.RPCExceptionCategory;
import org.evomaster.client.java.controller.api.dto.problem.rpc.exception.RPCExceptionType;
import org.evomaster.client.java.controller.problem.rpc.schema.EndpointSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.params.NamedTypedValue;
import org.evomaster.client.java.controller.problem.rpc.schema.types.TypeSchema;
import org.evomaster.client.java.utils.SimpleLogger;

public class RPCExceptionHandler {
    private static final String THRIFT_EXCEPTION_ROOT = "org.apache.thrift.TException";

    public static void handle(Object e, ActionResponseDto dto, EndpointSchema endpointSchema, RPCType type, Map<Class, Integer> levelsMap) {
        Object cause;
        Object exceptionToHandle = e;
        boolean isCause = false;
        if (UndeclaredThrowableException.class.isAssignableFrom(e.getClass()) && (cause = RPCExceptionHandler.getExceptionCause(e)) != null) {
            exceptionToHandle = cause;
            isCause = true;
        }
        boolean handled = false;
        RPCExceptionInfoDto exceptionInfoDto = null;
        try {
            exceptionInfoDto = RPCExceptionHandler.handleExceptionNameAndMessage(exceptionToHandle);
            RPCExceptionHandler.handleImportanceLevels(exceptionToHandle, exceptionInfoDto, levelsMap);
            handled = RPCExceptionHandler.handleDefinedException(exceptionToHandle, endpointSchema, type, exceptionInfoDto);
            if (RPCExceptionHandler.isFromTException(e)) {
                boolean bl = handled = RPCExceptionHandler.handleThrift(exceptionToHandle, endpointSchema, exceptionInfoDto) || handled;
            }
            if (handled) {
                dto.exceptionInfoDto = exceptionInfoDto;
                dto.exceptionInfoDto.isCauseOfUndeclaredThrowable = isCause;
                return;
            }
        }
        catch (ClassNotFoundException ex) {
            dto.exceptionInfoDto = exceptionInfoDto;
            throw new RuntimeException("ERROR: fail to handle defined exception for " + (Object)((Object)type) + " with error msg:" + ex);
        }
        RPCExceptionHandler.handleUnexpectedException(exceptionToHandle, exceptionInfoDto);
        dto.exceptionInfoDto = exceptionInfoDto;
        dto.exceptionInfoDto.isCauseOfUndeclaredThrowable = isCause;
    }

    private static void handleImportanceLevels(Object e, RPCExceptionInfoDto dto, Map<Class, Integer> levelsMap) {
        if (levelsMap == null) {
            return;
        }
        Integer level = levelsMap.get(e.getClass());
        if (level != null) {
            dto.importanceLevel = level;
        }
    }

    private static void handleUnexpectedException(Object e, RPCExceptionInfoDto dto) {
        dto.type = RPCExceptionType.UNEXPECTED_EXCEPTION;
    }

    private static boolean isFromTException(Object e) {
        try {
            return Class.forName(THRIFT_EXCEPTION_ROOT).isAssignableFrom(e.getClass());
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    private static RPCExceptionInfoDto handleExceptionNameAndMessage(Object e) {
        RPCExceptionInfoDto dto = new RPCExceptionInfoDto();
        if (Exception.class.isAssignableFrom(e.getClass())) {
            dto.exceptionName = e.getClass().getName();
            dto.exceptionMessage = RPCExceptionHandler.getExceptionMessage(e);
        } else {
            SimpleLogger.error("ERROR: the exception is not java.lang.Exception " + e.getClass().getName());
        }
        return dto;
    }

    private static boolean handleThrift(Object e, EndpointSchema endpointSchema, RPCExceptionInfoDto dto) {
        boolean handled = false;
        try {
            if (!RPCExceptionHandler.isRootThriftException(e)) {
                return false;
            }
            handled = RPCExceptionHandler.handleTException(e, dto);
            if (!handled) {
                SimpleLogger.uniqueWarn("Fail to extract exception type info for an exception " + e.getClass().getName());
            }
        }
        catch (ClassNotFoundException ex) {
            SimpleLogger.error("ERROR: in handling Thrift exception with error msg:", ex);
        }
        return handled;
    }

    private static boolean handleDefinedException(Object e, EndpointSchema endpointSchema, RPCType rpcType, RPCExceptionInfoDto dto) throws ClassNotFoundException {
        if (endpointSchema.getExceptions() == null) {
            return false;
        }
        for (NamedTypedValue p : endpointSchema.getExceptions()) {
            String type = ((TypeSchema)p.getType()).getFullTypeNameWithGenericType();
            if (type.equals(THRIFT_EXCEPTION_ROOT) || !RPCExceptionHandler.isInstanceOf(e, type)) continue;
            p.setValueBasedOnInstance(e);
            dto.exceptionDto = p.getDto();
            dto.type = RPCExceptionType.CUSTOMIZED_EXCEPTION;
            return true;
        }
        return false;
    }

    private static boolean handleTException(Object e, RPCExceptionInfoDto dto) {
        Method getType = null;
        try {
            getType = e.getClass().getDeclaredMethod("getType", new Class[0]);
            getType.setAccessible(true);
            int type = (Integer)getType.invoke(e, new Object[0]);
            dto.type = RPCExceptionHandler.getExceptionType(RPCExceptionHandler.extract(e), type);
            return true;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            SimpleLogger.error("Fail to get type of TException with getType() ", ex);
            return false;
        }
    }

    private static String getExceptionMessage(Object e) {
        Method getMessage = null;
        try {
            getMessage = e.getClass().getMethod("getMessage", new Class[0]);
            getMessage.setAccessible(true);
            return (String)getMessage.invoke(e, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            SimpleLogger.error("Error: fail to get message of the exception with ", ex);
            return null;
        }
    }

    private static Object getExceptionCause(Object e) {
        Method getCause = null;
        try {
            getCause = e.getClass().getMethod("getCause", new Class[0]);
            getCause.setAccessible(true);
            Object exp = getCause.invoke(e, new Object[0]);
            if (exp != null) {
                return exp;
            }
            getCause = e.getClass().getMethod("getUndeclaredThrowable", new Class[0]);
            getCause.setAccessible(true);
            return getCause.invoke(e, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            SimpleLogger.error("Error: fail to get message of the exception with ", ex);
            return null;
        }
    }

    private static boolean isRootThriftException(Object e) throws ClassNotFoundException {
        return Class.forName(THRIFT_EXCEPTION_ROOT).isInstance(e);
    }

    private static boolean isInstanceOf(Object e, String name) throws ClassNotFoundException {
        return Class.forName(name).isInstance(e);
    }

    private static RPCExceptionCategory extract(Object e) throws ClassNotFoundException {
        if (RPCExceptionHandler.isInstanceOf(e, "org.apache.thrift.TApplicationException")) {
            return RPCExceptionCategory.APPLICATION;
        }
        if (RPCExceptionHandler.isInstanceOf(e, "org.apache.thrift.protocol.TProtocolException")) {
            return RPCExceptionCategory.PROTOCOL;
        }
        if (RPCExceptionHandler.isInstanceOf(e, "org.apache.thrift.transport.TTransportException")) {
            return RPCExceptionCategory.TRANSPORT;
        }
        return RPCExceptionCategory.OTHERS;
    }

    private static RPCExceptionType getExceptionType(RPCExceptionCategory category, int intValue) {
        for (RPCExceptionType type : RPCExceptionType.values()) {
            if (type.intValue != intValue || type.category != category) continue;
            return type;
        }
        return null;
    }
}

