/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc.schema.types;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.evomaster.client.java.controller.api.dto.problem.rpc.RPCSupportedDataType;
import org.evomaster.client.java.controller.api.dto.problem.rpc.TypeDto;
import org.evomaster.client.java.controller.problem.rpc.schema.params.IntParam;
import org.evomaster.client.java.controller.problem.rpc.schema.types.DateType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.JavaDtoSpec;

public class LocalDateType
extends DateType {
    public static final String INSTANCE_LOCALDATE_OF_EPOCHDAY = "ofEpochDay";

    public LocalDateType(String type, String fullTypeName, Class<?> clazz, JavaDtoSpec spec) {
        super(type, fullTypeName, clazz, spec);
    }

    public LocalDateType(String type, String fullTypeName, Class<?> clazz, JavaDtoSpec spec, List<IntParam> dateFields) {
        super(type, fullTypeName, clazz, spec, dateFields);
    }

    public LocalDateType(JavaDtoSpec spec) {
        this(LocalDate.class.getSimpleName(), LocalDate.class.getName(), LocalDate.class, spec);
        this.setDateFields(Arrays.asList(this.year, this.month, this.day));
    }

    @Override
    public LocalDateType copy() {
        return new LocalDateType(this.spec);
    }

    @Override
    public Object getDateInstance(List<IntParam> values) {
        if (values.size() != 3) {
            throw new IllegalArgumentException("LocalDateType must have three integer parameters representing year, month and day of month");
        }
        return LocalDate.of((int)((Integer)values.get(0).getValue()), (Integer)values.get(1).getValue(), (int)((Integer)values.get(2).getValue()));
    }

    @Override
    public List<IntParam> getIntValues(Object date) {
        if (!(date instanceof LocalDate)) {
            throw new IllegalArgumentException("cannot handle the object instance which is not java.time.LocalDate");
        }
        List<IntParam> values = this.getDateFields().stream().map(x -> (IntParam)x.copyStructureWithProperties()).collect(Collectors.toList());
        ((IntParam)values.get(0)).setValue(((LocalDate)date).getYear());
        ((IntParam)values.get(1)).setValue(((LocalDate)date).getMonthValue());
        ((IntParam)values.get(2)).setValue(((LocalDate)date).getDayOfMonth());
        return values;
    }

    @Override
    public long getDateLong(List<IntParam> values) {
        return ((LocalDate)this.getDateInstance(values)).toEpochDay();
    }

    @Override
    public String getDateString(List<IntParam> values) {
        return String.format("%04d-%02d-%02d", values.get(0).getValue(), values.get(1).getValue(), values.get(2).getValue());
    }

    @Override
    public TypeDto getDto() {
        TypeDto dto = super.getDto();
        dto.depth = this.depth;
        dto.type = RPCSupportedDataType.LOCAL_DATE;
        return dto;
    }
}

