/*
 * Decompiled with CFR 0.152.
 */
package shaded.net.sf.jsqlparser.statement.merge;

import java.io.Serializable;
import java.util.List;
import shaded.net.sf.jsqlparser.expression.Expression;
import shaded.net.sf.jsqlparser.statement.merge.MergeOperation;
import shaded.net.sf.jsqlparser.statement.merge.MergeOperationVisitor;
import shaded.net.sf.jsqlparser.statement.update.UpdateSet;

public class MergeUpdate
implements Serializable,
MergeOperation {
    private List<UpdateSet> updateSets;
    private Expression andPredicate;
    private Expression whereCondition;
    private Expression deleteWhereCondition;

    public MergeUpdate() {
    }

    public MergeUpdate(List<UpdateSet> updateSets) {
        this.updateSets = updateSets;
    }

    public List<UpdateSet> getUpdateSets() {
        return this.updateSets;
    }

    public MergeUpdate setUpdateSets(List<UpdateSet> updateSets) {
        this.updateSets = updateSets;
        return this;
    }

    public Expression getAndPredicate() {
        return this.andPredicate;
    }

    public void setAndPredicate(Expression andPredicate) {
        this.andPredicate = andPredicate;
    }

    public Expression getWhereCondition() {
        return this.whereCondition;
    }

    public void setWhereCondition(Expression whereCondition) {
        this.whereCondition = whereCondition;
    }

    public Expression getDeleteWhereCondition() {
        return this.deleteWhereCondition;
    }

    public void setDeleteWhereCondition(Expression deleteWhereCondition) {
        this.deleteWhereCondition = deleteWhereCondition;
    }

    @Override
    public void accept(MergeOperationVisitor mergeOperationVisitor) {
        mergeOperationVisitor.visit(this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(" WHEN MATCHED");
        if (this.andPredicate != null) {
            b.append(" AND ").append(this.andPredicate.toString());
        }
        b.append(" THEN UPDATE SET ");
        UpdateSet.appendUpdateSetsTo(b, this.updateSets);
        if (this.whereCondition != null) {
            b.append(" WHERE ").append(this.whereCondition.toString());
        }
        if (this.deleteWhereCondition != null) {
            b.append(" DELETE WHERE ").append(this.deleteWhereCondition.toString());
        }
        return b.toString();
    }

    public MergeUpdate withAndPredicate(Expression andPredicate) {
        this.setAndPredicate(andPredicate);
        return this;
    }

    public MergeUpdate withWhereCondition(Expression whereCondition) {
        this.setWhereCondition(whereCondition);
        return this;
    }

    public MergeUpdate withDeleteWhereCondition(Expression deleteWhereCondition) {
        this.setDeleteWhereCondition(deleteWhereCondition);
        return this;
    }

    public <E extends Expression> E getAndPredicate(Class<E> type) {
        return (E)((Expression)type.cast(this.getAndPredicate()));
    }

    public <E extends Expression> E getWhereCondition(Class<E> type) {
        return (E)((Expression)type.cast(this.getWhereCondition()));
    }

    public <E extends Expression> E getDeleteWhereCondition(Class<E> type) {
        return (E)((Expression)type.cast(this.getDeleteWhereCondition()));
    }
}

